/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageContextPanel;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UsageContextPanelBase
extends JPanel
implements UsageContextPanel {
    protected final Project myProject;
    @NotNull
    protected final UsageViewPresentation myPresentation;
    protected volatile boolean isDisposed;

    public UsageContextPanelBase(@NotNull Project project, @NotNull UsageViewPresentation presentation) {
        this.myProject = project;
        this.myPresentation = presentation;
        this.setLayout(new BorderLayout());
        this.setBorder(IdeBorderFactory.createBorder());
    }

    @Override
    @NotNull
    public final JComponent createComponent() {
        this.isDisposed = false;
        return this;
    }

    public void dispose() {
        this.isDisposed = true;
    }

    @Override
    public final void updateLayout(final @Nullable List<UsageInfo> infos) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (UsageContextPanelBase.this.isDisposed || UsageContextPanelBase.this.myProject.isDisposed()) {
                    return;
                }
                UsageContextPanelBase.this.updateLayoutLater(infos);
            }
        });
    }

    protected abstract void updateLayoutLater(@Nullable List<UsageInfo> var1);
}

