/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsageInfo2UsageAdapter;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UsageInfoToUsageConverter {
    private UsageInfoToUsageConverter() {
    }

    @NotNull
    public static Usage convert(@NotNull TargetElementsDescriptor descriptor, @NotNull UsageInfo usageInfo) {
        PsiElement[] primaryElements = descriptor.getPrimaryElements();
        return UsageInfoToUsageConverter.convert(primaryElements, usageInfo);
    }

    @NotNull
    public static Usage convert(@NotNull PsiElement[] primaryElements, @NotNull UsageInfo usageInfo) {
        PsiElement usageElement = usageInfo.getElement();
        for (ReadWriteAccessDetector detector : (ReadWriteAccessDetector[])Extensions.getExtensions(ReadWriteAccessDetector.EP_NAME)) {
            if (!UsageInfoToUsageConverter.isReadWriteAccessibleElements(primaryElements, detector)) continue;
            ReadWriteAccessDetector.Access rwAccess = detector.getExpressionAccess(usageElement);
            return new ReadWriteAccessUsageInfo2UsageAdapter(usageInfo, rwAccess != ReadWriteAccessDetector.Access.Write, rwAccess != ReadWriteAccessDetector.Access.Read);
        }
        return new UsageInfo2UsageAdapter(usageInfo);
    }

    @NotNull
    public static Usage[] convert(@NotNull TargetElementsDescriptor descriptor, @NotNull UsageInfo[] usageInfos) {
        Usage[] usages = new Usage[usageInfos.length];
        for (int i = 0; i < usages.length; ++i) {
            usages[i] = UsageInfoToUsageConverter.convert(descriptor, usageInfos[i]);
        }
        return usages;
    }

    @NotNull
    public static Usage[] convert(final @NotNull PsiElement[] primaryElements, @NotNull UsageInfo[] usageInfos) {
        Usage[] usages = (Usage[])ContainerUtil.map((Object[])usageInfos, (Function)new Function<UsageInfo, Usage>(){

            public Usage fun(UsageInfo info) {
                return UsageInfoToUsageConverter.convert(primaryElements, info);
            }
        }, (Object[])new Usage[usageInfos.length]);
        return usages;
    }

    private static boolean isReadWriteAccessibleElements(@NotNull PsiElement[] elements, @NotNull ReadWriteAccessDetector detector) {
        if (elements.length == 0) {
            return false;
        }
        for (PsiElement element : elements) {
            if (detector.isReadWriteAccessible(element)) continue;
            return false;
        }
        return true;
    }

    public static class TargetElementsDescriptor {
        private final List<SmartPsiElementPointer<PsiElement>> myPrimarySearchedElements;
        private final List<SmartPsiElementPointer<PsiElement>> myAdditionalSearchedElements;
        private static final Function<SmartPsiElementPointer<PsiElement>, PsiElement> SMARTPOINTER_TO_ELEMENT_MAPPER = new Function<SmartPsiElementPointer<PsiElement>, PsiElement>(){

            public PsiElement fun(SmartPsiElementPointer<PsiElement> pointer) {
                return pointer.getElement();
            }
        };

        public TargetElementsDescriptor(@NotNull PsiElement element) {
            this(new PsiElement[]{element});
        }

        public TargetElementsDescriptor(@NotNull PsiElement[] primarySearchedElements) {
            this(primarySearchedElements, PsiElement.EMPTY_ARRAY);
        }

        public TargetElementsDescriptor(@NotNull PsiElement[] primarySearchedElements, @NotNull PsiElement[] additionalSearchedElements) {
            this.myPrimarySearchedElements = TargetElementsDescriptor.convertToSmartPointers(primarySearchedElements);
            this.myAdditionalSearchedElements = TargetElementsDescriptor.convertToSmartPointers(additionalSearchedElements);
        }

        @NotNull
        private static PsiElement[] convertToPsiElements(@NotNull List<SmartPsiElementPointer<PsiElement>> primary) {
            return (PsiElement[])ContainerUtil.toArray((Collection)ContainerUtil.mapNotNull(primary, SMARTPOINTER_TO_ELEMENT_MAPPER), PsiElement.ARRAY_FACTORY);
        }

        @NotNull
        private static List<SmartPsiElementPointer<PsiElement>> convertToSmartPointers(@NotNull PsiElement[] primaryElements) {
            if (primaryElements.length == 0) {
                return Collections.emptyList();
            }
            final SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(primaryElements[0].getProject());
            return ContainerUtil.mapNotNull((Object[])primaryElements, (Function)new Function<PsiElement, SmartPsiElementPointer<PsiElement>>(){

                public SmartPsiElementPointer<PsiElement> fun(PsiElement s) {
                    return smartPointerManager.createSmartPsiElementPointer(s);
                }
            });
        }

        @NotNull
        public PsiElement[] getPrimaryElements() {
            return TargetElementsDescriptor.convertToPsiElements(this.myPrimarySearchedElements);
        }

        @NotNull
        public PsiElement[] getAdditionalElements() {
            return TargetElementsDescriptor.convertToPsiElements(this.myAdditionalSearchedElements);
        }

        @NotNull
        public List<PsiElement> getAllElements() {
            PsiElement element;
            ArrayList<PsiElement> result = new ArrayList<PsiElement>(this.myPrimarySearchedElements.size() + this.myAdditionalSearchedElements.size());
            for (SmartPsiElementPointer<PsiElement> pointer : this.myPrimarySearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            for (SmartPsiElementPointer<PsiElement> pointer : this.myAdditionalSearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            return result;
        }

        @NotNull
        public List<SmartPsiElementPointer<PsiElement>> getAllElementPointers() {
            ArrayList<SmartPsiElementPointer<PsiElement>> result = new ArrayList<SmartPsiElementPointer<PsiElement>>(this.myPrimarySearchedElements.size() + this.myAdditionalSearchedElements.size());
            result.addAll(this.myPrimarySearchedElements);
            result.addAll(this.myAdditionalSearchedElements);
            return result;
        }
    }
}

