/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.table;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandableItemsHandlerFactory;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.Grayer;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.TableCell;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.SortableColumnModel;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessBridgeUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultRowSorter;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.jetbrains.annotations.NotNull;

public class JBTable
extends JTable
implements ComponentWithEmptyText,
ComponentWithExpandableItems<TableCell> {
    public static final int PREFERRED_SCROLLABLE_VIEWPORT_HEIGHT_IN_ROWS = 7;
    public static final int COLUMN_RESIZE_AREA_WIDTH = 3;
    private static final int DEFAULT_MIN_COLUMN_WIDTH = 15;
    private final StatusText myEmptyText;
    private final ExpandableItemsHandler<TableCell> myExpandableItemsHandler;
    private boolean myEnableAntialiasing;
    private int myRowHeight = -1;
    private boolean myRowHeightIsExplicitlySet;
    private boolean myRowHeightIsComputing;
    private boolean myUiUpdating = true;
    private Integer myMinRowHeight;
    private boolean myStriped;
    private AsyncProcessIcon myBusyIcon;
    private boolean myBusy;
    private int myMaxItemsForSizeCalculation = Integer.MAX_VALUE;

    public JBTable() {
        this(new DefaultTableModel());
    }

    public JBTable(TableModel model) {
        this(model, null);
    }

    public JBTable(TableModel model, TableColumnModel columnModel) {
        super(model, columnModel);
        if (ScreenReader.isActive()) {
            this.resetDefaultFocusTraversalKeys();
        }
        this.setSurrendersFocusOnKeystroke(true);
        this.myEmptyText = new StatusText(this){

            @Override
            protected boolean isStatusVisible() {
                return JBTable.this.isEmpty();
            }
        };
        this.myExpandableItemsHandler = ExpandableItemsHandlerFactory.install(this);
        this.setFillsViewportHeight(true);
        this.addMouseListener(new MyMouseListener());
        final TableModelListener modelListener = new TableModelListener(){

            @Override
            public void tableChanged(@NotNull TableModelEvent e) {
                JBTable.this.onTableChanged(e);
            }
        };
        if (this.getModel() != null) {
            this.getModel().addTableModelListener(modelListener);
        }
        this.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                JBTable.this.repaintViewport();
                if (evt.getOldValue() instanceof TableModel) {
                    ((TableModel)evt.getOldValue()).removeTableModelListener(modelListener);
                }
                if (evt.getNewValue() instanceof TableModel) {
                    ((TableModel)evt.getNewValue()).addTableModelListener(modelListener);
                }
            }
        });
        this.myUiUpdating = false;
        new MyCellEditorRemover();
    }

    protected void onTableChanged(@NotNull TableModelEvent e) {
        if (!this.myRowHeightIsExplicitlySet) {
            this.myRowHeight = -1;
        }
        if (e.getType() == -1 && this.isEmpty() || e.getType() == 1 && !this.isEmpty()) {
            this.repaintViewport();
        }
    }

    @Override
    public int getRowHeight() {
        if (this.myRowHeightIsComputing) {
            return super.getRowHeight();
        }
        if (this.myRowHeight < 0) {
            try {
                this.myRowHeightIsComputing = true;
                this.myRowHeight = this.calculateRowHeight();
            }
            finally {
                this.myRowHeightIsComputing = false;
            }
        }
        if (this.myMinRowHeight == null) {
            this.myMinRowHeight = this.getFontMetrics(UIManager.getFont("Label.font")).getHeight();
        }
        return Math.max(this.myRowHeight, this.myMinRowHeight);
    }

    protected int calculateRowHeight() {
        int result = -1;
        for (int row = 0; row < Math.min(this.getRowCount(), this.myMaxItemsForSizeCalculation); ++row) {
            for (int column = 0; column < Math.min(this.getColumnCount(), this.myMaxItemsForSizeCalculation); ++column) {
                Object value;
                Component component;
                TableCellRenderer renderer = this.getCellRenderer(row, column);
                if (renderer == null || (component = renderer.getTableCellRendererComponent(this, value = this.getValueAt(row, column), true, true, row, column)) == null) continue;
                Dimension size = component.getPreferredSize();
                result = Math.max(size.height, result);
            }
        }
        return result;
    }

    public void setShowColumns(boolean value) {
        JTableHeader tableHeader = this.getTableHeader();
        tableHeader.setVisible(value);
        tableHeader.setPreferredSize(value ? null : new Dimension());
    }

    @Override
    public void setRowHeight(int rowHeight) {
        if (!this.myUiUpdating || !UIUtil.isUnderGTKLookAndFeel()) {
            this.myRowHeight = rowHeight;
            this.myRowHeightIsExplicitlySet = true;
        }
        super.setRowHeight(rowHeight);
    }

    @Override
    public void updateUI() {
        this.myUiUpdating = true;
        try {
            super.updateUI();
            this.myMinRowHeight = null;
        }
        finally {
            this.myUiUpdating = false;
        }
    }

    private void repaintViewport() {
        if (!this.isDisplayable() || !this.isVisible()) {
            return;
        }
        Container p = this.getParent();
        if (p instanceof JBViewport) {
            p.repaint();
        }
    }

    @Override
    @NotNull
    protected JTableHeader createDefaultTableHeader() {
        return new JBTableHeader();
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (AccessBridgeUtil.isWorkerThread()) {
            TableCellRenderer renderer = super.getCellRenderer(row, column);
            if (renderer == null) {
                return null;
            }
            return (table, value, isSelected, hasFocus, row2, column2) -> (Component)AccessBridgeUtil.invokeAndWait(() -> renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row2, column2));
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public void setModel(@NotNull TableModel model) {
        super.setModel(model);
        if (model instanceof SortableColumnModel) {
            SortableColumnModel sortableModel = (SortableColumnModel)model;
            if (sortableModel.isSortable()) {
                TableRowSorter<TableModel> rowSorter = this.createRowSorter(model);
                rowSorter.setSortsOnUpdates(this.isSortOnUpdates());
                this.setRowSorter(rowSorter);
                RowSorter.SortKey sortKey = sortableModel.getDefaultSortKey();
                if (sortKey != null && sortKey.getColumn() >= 0 && sortKey.getColumn() < model.getColumnCount() && sortableModel.getColumnInfos()[sortKey.getColumn()].isSortable()) {
                    rowSorter.setSortKeys(Collections.singletonList(sortKey));
                }
            } else {
                RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
                if (rowSorter instanceof DefaultColumnInfoBasedRowSorter) {
                    this.setRowSorter(null);
                }
            }
        }
    }

    protected boolean isSortOnUpdates() {
        return true;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        if (this.myEnableAntialiasing) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
        }
        super.paintComponent(g);
        this.myEmptyText.paint(this, g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (this.myEnableAntialiasing) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
        }
        super.paintChildren(g);
    }

    public void setEnableAntialiasing(boolean flag) {
        this.myEnableAntialiasing = flag;
    }

    public static DefaultCellEditor createBooleanEditor() {
        return new DefaultCellEditor(new JCheckBox()){
            {
                ((JCheckBox)this.getComponent()).setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                component.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return component;
            }
        };
    }

    public void resetDefaultFocusTraversalKeys() {
        KeyboardFocusManager m = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        for (Integer each : Arrays.asList(0, 1, 2, 3)) {
            this.setFocusTraversalKeys(each, m.getDefaultFocusTraversalKeys(each));
        }
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        return this.myEmptyText;
    }

    @Override
    @NotNull
    public ExpandableItemsHandler<TableCell> getExpandableItemsHandler() {
        return this.myExpandableItemsHandler;
    }

    @Override
    public void setExpandableItemsEnabled(boolean enabled) {
        this.myExpandableItemsHandler.setEnabled(enabled);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify(this) && this.myBusyIcon != null) {
            this.remove(this.myBusyIcon);
            Disposer.dispose((Disposable)this.myBusyIcon);
            this.myBusyIcon = null;
        }
    }

    @Override
    public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), " ");
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    @Override
    public void paint(@NotNull Graphics g) {
        if (!this.isEnabled()) {
            g = new Grayer((Graphics2D)g, this.getBackground());
        }
        super.paint((Graphics)g);
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    public void setPaintBusy(boolean paintBusy) {
        if (this.myBusy == paintBusy) {
            return;
        }
        this.myBusy = paintBusy;
        this.updateBusy();
    }

    private void updateBusy() {
        if (this.myBusy && this.myBusyIcon == null) {
            this.myBusyIcon = new AsyncProcessIcon(this.toString()).setUseMask(false);
            this.myBusyIcon.setOpaque(false);
            this.myBusyIcon.setPaintPassiveIcon(false);
            this.add(this.myBusyIcon);
        }
        if (this.myBusyIcon != null) {
            if (this.myBusy) {
                this.myBusyIcon.resume();
            } else {
                this.myBusyIcon.suspend();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (JBTable.this.myBusyIcon != null) {
                            JBTable.this.repaint();
                        }
                    }
                });
            }
            if (this.myBusyIcon != null) {
                this.myBusyIcon.updateLocation(this);
            }
        }
    }

    public boolean isStriped() {
        return this.myStriped;
    }

    public void setStriped(boolean striped) {
        this.myStriped = striped;
        if (striped) {
            this.getColumnModel().setColumnMargin(0);
            this.setIntercellSpacing(new Dimension(this.getIntercellSpacing().width, 0));
            this.setShowGrid(false);
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        TableCellEditor editor;
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        if (e instanceof KeyEvent) {
            if (!UIUtil.isReallyTypedEvent((KeyEvent)((KeyEvent)e)) || ((KeyEvent)e).getKeyChar() == '\uffff') {
                return false;
            }
            SpeedSearchSupply supply = SpeedSearchSupply.getSupply(this);
            if (supply != null && supply.isPopupActive()) {
                return false;
            }
        }
        if ((editor = this.getCellEditor(row, column)) != null && editor.isCellEditable(e)) {
            this.editorComp = this.prepareEditor(editor, row, column);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellRect(row, column, false));
            this.add(this.editorComp);
            this.editorComp.validate();
            if (this.surrendersFocusOnKeyStroke()) {
                final IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent(this);
                focusManager.setTypeaheadEnabled(false);
                focusManager.requestFocus(this.editorComp, true).doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        focusManager.setTypeaheadEnabled(true);
                    }
                });
            }
            this.setCellEditor(editor);
            this.setEditingRow(row);
            this.setEditingColumn(column);
            editor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean getSurrendersFocusOnKeystroke() {
        return false;
    }

    public boolean surrendersFocusOnKeyStroke() {
        return super.getSurrendersFocusOnKeystroke();
    }

    private static boolean isTableDecorationSupported() {
        return UIUtil.isUnderAlloyLookAndFeel() || UIUtil.isUnderNativeMacLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderNimbusLookAndFeel() || UIUtil.isUnderWindowsLookAndFeel();
    }

    @Override
    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
        Component result = super.prepareRenderer(renderer, row, column);
        if (UIUtil.isUnderGTKLookAndFeel()) {
            UIUtil.changeBackGround((Component)this, (Color)UIUtil.getTreeTextBackground());
        }
        if (JBTable.isTableDecorationSupported() && this.isStriped() && result instanceof JComponent) {
            Color bg = row % 2 == 1 ? this.getBackground() : UIUtil.getDecoratedRowColor();
            JComponent c = (JComponent)result;
            boolean cellSelected = this.isCellSelected(row, column);
            if (!cellSelected) {
                c.setOpaque(true);
                c.setBackground(bg);
                for (Component child : c.getComponents()) {
                    child.setBackground(bg);
                }
            }
        }
        if (this.myExpandableItemsHandler.getExpandedItems().contains(new TableCell(row, column))) {
            result = ExpandedItemRendererComponentWrapper.wrap(result);
        }
        return result;
    }

    protected TableRowSorter<TableModel> createRowSorter(TableModel model) {
        return new DefaultColumnInfoBasedRowSorter(model);
    }

    public int getExpandedColumnWidth(int columnToExpand) {
        int expandedWidth = this.getPreferredHeaderWidth(columnToExpand);
        for (int row = 0; row < this.getRowCount(); ++row) {
            TableCellRenderer cellRenderer = this.getCellRenderer(row, columnToExpand);
            if (cellRenderer == null) continue;
            Component c = this.prepareRenderer(cellRenderer, row, columnToExpand);
            expandedWidth = Math.max(expandedWidth, c.getPreferredSize().width);
        }
        return expandedWidth;
    }

    private int getPreferredHeaderWidth(int columnIdx) {
        TableColumn column = this.getColumnModel().getColumn(columnIdx);
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            JTableHeader header = this.getTableHeader();
            if (header == null) {
                return 15;
            }
            renderer = header.getDefaultRenderer();
        }
        Object headerValue = column.getHeaderValue();
        Component headerCellRenderer = renderer.getTableCellRendererComponent(this, headerValue, false, false, -1, columnIdx);
        return headerCellRenderer.getPreferredSize().width;
    }

    public void setMaxItemsForSizeCalculation(int maxItemsForSizeCalculation) {
        this.myMaxItemsForSizeCalculation = maxItemsForSizeCalculation;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJBTable();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJBTable
    extends JTable.AccessibleJTable {
        protected AccessibleJBTable() {
            super(JBTable.this);
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            int column = this.getAccessibleColumnAtIndex(i);
            int row = this.getAccessibleRowAtIndex(i);
            return new AccessibleJBTableCell((JTable)JBTable.this, row, column, this.getAccessibleIndexAt(row, column));
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            int column = JBTable.this.columnAtPoint(p);
            int row = JBTable.this.rowAtPoint(p);
            if (column != -1 && row != -1) {
                return this.getAccessibleChild(this.getAccessibleIndexAt(row, column));
            }
            return null;
        }

        protected class AccessibleJBTableCell
        extends JTable.AccessibleJTable.AccessibleJTableCell {
            private final int myRow;
            private final int myColumn;

            public AccessibleJBTableCell(JTable table, int row, int columns, int index) {
                super(AccessibleJBTable.this, table, row, columns, index);
                this.myRow = row;
                this.myColumn = columns;
            }

            @Override
            protected Component getCurrentComponent() {
                return JBTable.this.getCellRenderer(this.myRow, this.myColumn).getTableCellRendererComponent(JBTable.this, JBTable.this.getValueAt(this.myRow, this.myColumn), false, false, this.myRow, this.myColumn);
            }

            @Override
            protected AccessibleContext getCurrentAccessibleContext() {
                Component c = this.getCurrentComponent();
                if (c instanceof Accessible) {
                    return c.getAccessibleContext();
                }
                return null;
            }
        }
    }

    protected class JBTableHeader
    extends JTableHeader {
        public JBTableHeader() {
            super(JBTable.this.columnModel);
            JBTable.this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(@NotNull PropertyChangeEvent evt) {
                    JBTableHeader.this.revalidate();
                    JBTableHeader.this.repaint();
                }
            });
        }

        @Override
        public void paint(@NotNull Graphics g) {
            if (JBTable.this.myEnableAntialiasing) {
                GraphicsUtil.setupAntialiasing((Graphics)g);
            }
            if (!JBTable.this.isEnabled()) {
                g = new Grayer((Graphics2D)g, this.getBackground());
            }
            super.paint((Graphics)g);
        }

        @Override
        public String getToolTipText(@NotNull MouseEvent event) {
            TableModel model = JBTable.this.getModel();
            if (model instanceof SortableColumnModel) {
                String tooltipText;
                int i = this.columnAtPoint(event.getPoint());
                int infoIndex = i >= 0 ? JBTable.this.convertColumnIndexToModel(i) : -1;
                ColumnInfo[] columnInfos = ((SortableColumnModel)model).getColumnInfos();
                String string = tooltipText = infoIndex >= 0 && infoIndex < columnInfos.length ? columnInfos[infoIndex].getTooltipText() : null;
                if (tooltipText != null) {
                    return tooltipText;
                }
            }
            return super.getToolTipText(event);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            int columnToPack;
            if (e.getID() == 500 && e.getButton() == 1 && (columnToPack = this.getColumnToPack(e.getPoint())) != -1 && this.canResize(columnToPack)) {
                if (e.getClickCount() % 2 == 0) {
                    this.packColumn(columnToPack);
                }
                return;
            }
            super.processMouseEvent(e);
        }

        protected void packColumn(int columnToPack) {
            TableColumn column = this.getColumnModel().getColumn(columnToPack);
            int currentWidth = column.getWidth();
            int expandedWidth = JBTable.this.getExpandedColumnWidth(columnToPack);
            int newWidth = this.getColumnModel().getColumnMargin() + (currentWidth >= expandedWidth ? JBTable.this.getPreferredHeaderWidth(columnToPack) : expandedWidth);
            this.setResizingColumn(column);
            column.setWidth(newWidth);
            Dimension tableSize = JBTable.this.getSize();
            tableSize.width += newWidth - column.getWidth();
            JBTable.this.setSize(tableSize);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    JBTableHeader.this.setResizingColumn(null);
                }
            });
        }

        private int getColumnToPack(Point p) {
            boolean atLeftBound;
            int viewColumnIdx = JBTable.this.columnAtPoint(p);
            if (viewColumnIdx == -1) {
                return -1;
            }
            Rectangle headerRect = this.getHeaderRect(viewColumnIdx);
            boolean bl = atLeftBound = p.x - headerRect.x < 3;
            if (atLeftBound) {
                return viewColumnIdx == 0 ? viewColumnIdx : viewColumnIdx - 1;
            }
            boolean atRightBound = headerRect.x + headerRect.width - p.x < 3;
            return atRightBound ? viewColumnIdx : -1;
        }

        private boolean canResize(int columnIdx) {
            TableColumnModel columnModel = this.getColumnModel();
            return this.resizingAllowed && columnModel.getColumn(columnIdx).getResizable();
        }
    }

    protected static class DefaultColumnInfoBasedRowSorter
    extends TableRowSorter<TableModel> {
        public DefaultColumnInfoBasedRowSorter(TableModel model) {
            super(model);
            this.setModelWrapper(new TableRowSorterModelWrapper(model));
            this.setMaxSortKeys(1);
        }

        @Override
        public Comparator<?> getComparator(int column) {
            TableModel model = (TableModel)this.getModel();
            if (model instanceof SortableColumnModel) {
                Comparator comparator;
                ColumnInfo[] columnInfos = ((SortableColumnModel)model).getColumnInfos();
                if (column >= 0 && column < columnInfos.length && (comparator = columnInfos[column].getComparator()) != null) {
                    return comparator;
                }
            }
            return super.getComparator(column);
        }

        @Override
        protected boolean useToString(int column) {
            return false;
        }

        @Override
        public boolean isSortable(int column) {
            TableModel model = (TableModel)this.getModel();
            if (model instanceof SortableColumnModel) {
                ColumnInfo[] columnInfos = ((SortableColumnModel)model).getColumnInfos();
                if (column >= 0 && column < columnInfos.length) {
                    return columnInfos[column].isSortable() && columnInfos[column].getComparator() != null;
                }
            }
            return false;
        }

        private class TableRowSorterModelWrapper
        extends DefaultRowSorter.ModelWrapper<TableModel, Integer> {
            private final TableModel myModel;

            private TableRowSorterModelWrapper(TableModel model) {
                this.myModel = model;
            }

            @Override
            public TableModel getModel() {
                return this.myModel;
            }

            @Override
            public int getColumnCount() {
                return this.myModel.getColumnCount();
            }

            @Override
            public int getRowCount() {
                return this.myModel.getRowCount();
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (this.myModel instanceof SortableColumnModel) {
                    return ((SortableColumnModel)this.myModel).getRowValue(row);
                }
                return this.myModel.getValueAt(row, column);
            }

            @Override
            @NotNull
            public String getStringValueAt(int row, int column) {
                TableStringConverter converter = DefaultColumnInfoBasedRowSorter.this.getStringConverter();
                if (converter != null) {
                    String value = converter.toString(this.myModel, row, column);
                    if (value != null) {
                        return value;
                    }
                    return "";
                }
                Object o = this.getValueAt(row, column);
                if (o == null) {
                    return "";
                }
                String string = o.toString();
                if (string == null) {
                    return "";
                }
                return string;
            }

            @Override
            public Integer getIdentifier(int index) {
                return index;
            }
        }
    }

    private final class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            int row;
            int[] selectedRows;
            if (JBSwingUtilities.isRightMouseButton((MouseEvent)e) && (selectedRows = JBTable.this.getSelectedRows()).length < 2 && (row = JBTable.this.rowAtPoint(e.getPoint())) != -1) {
                JBTable.this.getSelectionModel().setSelectionInterval(row, row);
            }
        }
    }

    private final class MyCellEditorRemover
    extends Activatable.Adapter
    implements PropertyChangeListener {
        private boolean myIsActive = false;

        public MyCellEditorRemover() {
            JBTable.this.addPropertyChangeListener("tableCellEditor", this);
            new UiNotifyConnector(JBTable.this, this);
        }

        public void activate() {
            if (!this.myIsActive) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", this);
            }
            this.myIsActive = true;
        }

        public void deactivate() {
            if (this.myIsActive) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this);
            }
            this.myIsActive = false;
        }

        @Override
        public void hideNotify() {
            this.removeCellEditor();
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent e) {
            if ("tableCellEditor".equals(e.getPropertyName())) {
                this.tableCellEditorChanged(e.getOldValue(), e.getNewValue());
            } else if ("permanentFocusOwner".equals(e.getPropertyName())) {
                this.permanentFocusOwnerChanged();
            }
        }

        private void tableCellEditorChanged(Object from, Object to) {
            boolean editingStopped;
            boolean editingStarted = from == null && to != null;
            boolean bl = editingStopped = from != null && to == null;
            if (editingStarted) {
                this.activate();
            } else if (editingStopped) {
                this.deactivate();
            }
        }

        private void permanentFocusOwnerChanged() {
            if (!JBTable.this.isEditing()) {
                return;
            }
            final IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent(JBTable.this);
            focusManager.doWhenFocusSettlesDown(new ExpirableRunnable(){

                @Override
                public boolean isExpired() {
                    return !JBTable.this.isEditing();
                }

                @Override
                public void run() {
                    Component c = focusManager.getFocusOwner();
                    if (UIUtil.isMeaninglessFocusOwner((Component)c)) {
                        return;
                    }
                    while (c != null) {
                        if (c instanceof JPopupMenu) {
                            c = ((JPopupMenu)c).getInvoker();
                        }
                        if (c == JBTable.this) {
                            return;
                        }
                        if (c instanceof Window) {
                            if (c != SwingUtilities.getWindowAncestor(JBTable.this)) break;
                            MyCellEditorRemover.this.removeCellEditor();
                            break;
                        }
                        c = c.getParent();
                    }
                }
            });
        }

        private void removeCellEditor() {
            TableCellEditor cellEditor = JBTable.this.getCellEditor();
            if (cellEditor != null && !cellEditor.stopCellEditing()) {
                cellEditor.cancelCellEditing();
            }
        }
    }
}

