/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnchorableComponent;
import com.intellij.ui.ColorUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBLabel
extends JLabel
implements AnchorableComponent {
    private UIUtil.ComponentStyle myComponentStyle = UIUtil.ComponentStyle.REGULAR;
    private UIUtil.FontColor myFontColor = UIUtil.FontColor.NORMAL;
    private JComponent myAnchor = null;
    private JEditorPane myEditorPane = null;
    private JLabel myIconLabel = null;
    private boolean myMultiline = false;

    public JBLabel() {
    }

    public JBLabel(@NotNull UIUtil.ComponentStyle componentStyle) {
        this.setComponentStyle(componentStyle);
    }

    public JBLabel(@Nullable Icon image) {
        super(image);
    }

    public JBLabel(@NotNull String text) {
        super(text);
    }

    public JBLabel(@NotNull String text, @NotNull UIUtil.ComponentStyle componentStyle) {
        super(text);
        this.setComponentStyle(componentStyle);
    }

    public JBLabel(@NotNull String text, @NotNull UIUtil.ComponentStyle componentStyle, @NotNull UIUtil.FontColor fontColor) {
        super(text);
        this.setComponentStyle(componentStyle);
        this.setFontColor(fontColor);
    }

    public JBLabel(@NotNull String text, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    public JBLabel(@Nullable Icon image, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        super(image, horizontalAlignment);
    }

    public JBLabel(@NotNull String text, @Nullable Icon icon, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    public void setComponentStyle(@NotNull UIUtil.ComponentStyle componentStyle) {
        this.myComponentStyle = componentStyle;
        UIUtil.applyStyle((UIUtil.ComponentStyle)componentStyle, (Component)this);
    }

    public UIUtil.ComponentStyle getComponentStyle() {
        return this.myComponentStyle;
    }

    public UIUtil.FontColor getFontColor() {
        return this.myFontColor;
    }

    public void setFontColor(@NotNull UIUtil.FontColor fontColor) {
        this.myFontColor = fontColor;
    }

    @Override
    public Color getForeground() {
        if (!this.isEnabled()) {
            return UIUtil.getLabelDisabledForeground();
        }
        if (this.myFontColor != null) {
            return UIUtil.getLabelFontColor((UIUtil.FontColor)this.myFontColor);
        }
        return super.getForeground();
    }

    @Override
    public void setForeground(Color fg) {
        this.myFontColor = null;
        super.setForeground(fg);
        if (this.myEditorPane != null) {
            this.updateStyle(this.myEditorPane);
        }
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myAnchor != null && this.myAnchor != this) {
            return this.myAnchor.getPreferredSize();
        }
        if (this.myEditorPane != null) {
            return this.getLayout().preferredLayoutSize(this);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.myAnchor != null && this.myAnchor != this) {
            return this.myAnchor.getMinimumSize();
        }
        if (this.myEditorPane != null) {
            return this.getLayout().minimumLayoutSize(this);
        }
        return super.getMinimumSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.myEditorPane == null) {
            super.paintComponent(g);
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (this.myEditorPane != null) {
            this.myEditorPane.setText(this.getText());
            this.updateStyle(this.myEditorPane);
            this.checkMultiline();
        }
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        if (this.myIconLabel != null) {
            this.myIconLabel.setIcon(icon);
            this.updateLayout();
        }
    }

    private void checkMultiline() {
        this.myMultiline = StringUtil.removeHtmlTags((String)this.getText()).contains(SystemProperties.getLineSeparator());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.myEditorPane != null) {
            this.updateStyle(this.myEditorPane);
        }
    }

    @Override
    public void setIconTextGap(int iconTextGap) {
        super.setIconTextGap(iconTextGap);
        if (this.myEditorPane != null) {
            this.updateLayout();
        }
    }

    protected void updateLayout() {
        this.setLayout(new BorderLayout(this.getIcon() == null ? 0 : this.getIconTextGap(), 0));
        this.add((Component)this.myIconLabel, "West");
        this.add((Component)this.myEditorPane, "Center");
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myEditorPane != null) {
            this.setCopyable(false);
            this.setCopyable(true);
        }
    }

    public JBLabel setCopyable(boolean copyable) {
        if (copyable ^ this.myEditorPane != null) {
            if (this.myEditorPane == null) {
                final JBLabel ellipsisLabel = new JBLabel("...");
                this.myIconLabel = new JLabel(this.getIcon());
                this.myEditorPane = new JEditorPane(){

                    @Override
                    public void paint(Graphics g) {
                        boolean paintEllipsis;
                        Dimension size = this.getSize();
                        boolean bl = paintEllipsis = this.getPreferredSize().width > size.width && !JBLabel.this.myMultiline;
                        if (!paintEllipsis) {
                            super.paint(g);
                        } else {
                            Dimension ellipsisSize = ellipsisLabel.getPreferredSize();
                            int endOffset = size.width - ellipsisSize.width;
                            try {
                                endOffset = this.modelToView((int)(this.viewToModel((Point)new Point((int)endOffset, (int)0)) - 1)).x;
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                            Shape oldClip = g.getClip();
                            g.clipRect(0, 0, endOffset, size.height);
                            super.paint(g);
                            g.setClip(oldClip);
                            g.translate(endOffset, 0);
                            ellipsisLabel.setSize(ellipsisSize);
                            ellipsisLabel.paint(g);
                            g.translate(-endOffset, 0);
                        }
                    }
                };
                this.myEditorPane.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (JBLabel.this.myEditorPane == null) {
                            return;
                        }
                        int caretPosition = JBLabel.this.myEditorPane.getCaretPosition();
                        JBLabel.this.myEditorPane.setSelectionStart(caretPosition);
                        JBLabel.this.myEditorPane.setSelectionEnd(caretPosition);
                    }
                });
                this.myEditorPane.setContentType("text/html");
                this.myEditorPane.setEditable(false);
                this.myEditorPane.setBackground(UIUtil.TRANSPARENT_COLOR);
                this.myEditorPane.setOpaque(false);
                this.myEditorPane.setBorder(null);
                UIUtil.putClientProperty((JComponent)this.myEditorPane, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, Collections.singleton(ellipsisLabel));
                this.myEditorPane.setEditorKit(UIUtil.getHTMLEditorKit());
                this.updateStyle(this.myEditorPane);
                this.myEditorPane.setText(this.getText());
                this.checkMultiline();
                this.myEditorPane.setCaretPosition(0);
                this.updateLayout();
            } else {
                this.removeAll();
                this.myEditorPane = null;
                this.myIconLabel = null;
            }
        }
        return this;
    }

    private void updateStyle(@NotNull JEditorPane pane) {
        EditorKit kit = pane.getEditorKit();
        if (kit instanceof HTMLEditorKit) {
            StyleSheet css = ((HTMLEditorKit)kit).getStyleSheet();
            css.addRule("body, p {color:#" + ColorUtil.toHex((Color)this.getForeground()) + ";" + "font-family:" + this.getFont().getFamily() + ";" + "font-size:" + this.getFont().getSize() + "pt;" + "white-space:nowrap;}");
        }
    }
}

