/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListCellRendererWrapper<T>
implements ListCellRenderer {
    private final ListCellRenderer myDefaultRenderer;
    private boolean mySeparator;
    private Icon myIcon;
    private String myText;
    private String myToolTipText;
    private Color myForeground;
    private Color myBackground;
    private Font myFont;
    private FList<Pair<Object, Object>> myProperties = FList.emptyList();

    public ListCellRendererWrapper() {
        BasicComboBoxRenderer renderer = new JComboBox().getRenderer();
        if (renderer == null) {
            renderer = new BasicComboBoxRenderer();
            Logger.getInstance(this.getClass()).error("LaF: " + UIManager.getLookAndFeel());
        }
        this.myDefaultRenderer = renderer;
    }

    public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.mySeparator = false;
        this.myIcon = null;
        this.myText = null;
        this.myForeground = null;
        this.myBackground = null;
        this.myFont = null;
        this.myToolTipText = null;
        this.myProperties = FList.emptyList();
        Object t = value;
        this.customize(list, t, index, isSelected, cellHasFocus);
        if (this.mySeparator) {
            TitledSeparator separator = new TitledSeparator(this.myText);
            separator.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            if (!UIUtil.isUnderGTKLookAndFeel()) {
                separator.setOpaque(false);
                separator.setBackground(UIUtil.TRANSPARENT_COLOR);
                separator.getLabel().setOpaque(false);
                separator.getLabel().setBackground(UIUtil.TRANSPARENT_COLOR);
            }
            return separator;
        }
        Component component = this.myDefaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            label.setIcon(this.myIcon);
            if (this.myText != null) {
                label.setText(this.myText);
            }
            if (this.myForeground != null) {
                label.setForeground(this.myForeground);
            }
            if (this.myBackground != null && !isSelected) {
                label.setBackground(this.myBackground);
            }
            if (this.myFont != null) {
                label.setFont(this.myFont);
            }
            label.setToolTipText(this.myToolTipText);
            for (Pair pair : this.myProperties) {
                label.putClientProperty(pair.first, pair.second);
            }
        }
        return component;
    }

    public abstract void customize(JList var1, T var2, int var3, boolean var4, boolean var5);

    public final void setSeparator() {
        this.mySeparator = true;
    }

    public final void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
    }

    public final void setText(@Nullable String text) {
        this.myText = text;
    }

    public final void setToolTipText(@Nullable String toolTipText) {
        this.myToolTipText = toolTipText;
    }

    public final void setForeground(@Nullable Color foreground) {
        this.myForeground = foreground;
    }

    public final void setBackground(@Nullable Color background) {
        this.myBackground = background;
    }

    public final void setFont(@Nullable Font font) {
        this.myFont = font;
    }

    public final void setClientProperty(@NotNull Object key, @Nullable Object value) {
        this.myProperties = this.myProperties.prepend((Object)Pair.pair((Object)key, (Object)value));
    }
}

