/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;

public class IdeaTestUtil
extends PlatformTestUtil {
    private static final String MOCK_JDK_DIR_NAME_PREFIX = "mockJDK-";

    public static void main(String[] args) {
        IdeaTestUtil.printDetectedPerformanceTimings();
    }

    public static void printDetectedPerformanceTimings() {
        System.out.println(Timings.getStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withLevel(Module module, LanguageLevel level, Runnable r) {
        LanguageLevelProjectExtension projectExt = LanguageLevelProjectExtension.getInstance(module.getProject());
        LanguageLevel projectLevel = projectExt.getLanguageLevel();
        LanguageLevel moduleLevel = LanguageLevelModuleExtensionImpl.getInstance(module).getLanguageLevel();
        try {
            projectExt.setLanguageLevel(level);
            IdeaTestUtil.setModuleLanguageLevel(module, level);
            r.run();
        }
        finally {
            IdeaTestUtil.setModuleLanguageLevel(module, moduleLevel);
            projectExt.setLanguageLevel(projectLevel);
        }
    }

    public static void setModuleLanguageLevel(Module module, LanguageLevel level) {
        LanguageLevelModuleExtensionImpl modifiable = (LanguageLevelModuleExtensionImpl)LanguageLevelModuleExtensionImpl.getInstance(module).getModifiableModel(true);
        modifiable.setLanguageLevel(level);
        modifiable.commit();
    }

    public static Sdk getMockJdk17() {
        return IdeaTestUtil.getMockJdk17("java 1.7");
    }

    public static Sdk getMockJdk17(@NotNull String name) {
        return JavaSdk.getInstance().createJdk(name, IdeaTestUtil.getMockJdk17Path().getPath(), false);
    }

    public static Sdk getMockJdk18() {
        return JavaSdk.getInstance().createJdk("java 1.8", IdeaTestUtil.getMockJdk18Path().getPath(), false);
    }

    public static Sdk getMockJdk14() {
        return JavaSdk.getInstance().createJdk("java 1.4", IdeaTestUtil.getMockJdk14Path().getPath(), false);
    }

    public static File getMockJdk14Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.4");
    }

    public static File getMockJdk17Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.7");
    }

    public static File getMockJdk18Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.8");
    }

    public static String getMockJdkVersion(String path2) {
        String name = PathUtil.getFileName(path2);
        if (name.startsWith(MOCK_JDK_DIR_NAME_PREFIX)) {
            return "java " + StringUtil.trimStart((String)name, (String)MOCK_JDK_DIR_NAME_PREFIX);
        }
        return null;
    }

    private static File getPathForJdkNamed(String name) {
        File mockJdkCEPath = new File(PathManager.getHomePath(), "java/" + name);
        return mockJdkCEPath.exists() ? mockJdkCEPath : new File(PathManager.getHomePath(), "community/java/" + name);
    }

    public static Sdk getWebMockJdk17() {
        Sdk jdk = IdeaTestUtil.getMockJdk17();
        IdeaTestUtil.addWebJarsTo(jdk);
        return jdk;
    }

    public static void addWebJarsTo(@NotNull Sdk jdk) {
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/jsp-api.jar"), OrderRootType.CLASSES);
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/servlet-api.jar"), OrderRootType.CLASSES);
        sdkModificator.commitChanges();
    }

    private static VirtualFile findJar(String name) {
        String path2 = PathManager.getHomePath() + '/' + name;
        VirtualFile file = VfsTestUtil.findFileByCaseSensitivePath((String)path2);
        VirtualFile jar = JarFileSystem.getInstance().getJarRootForLocalFile(file);
        assert (jar != null) : "no .jar for: " + path2;
        return jar;
    }

    public static void setTestVersion(@NotNull JavaSdkVersion testVersion, @NotNull Module module, @NotNull Disposable parentDisposable) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
        final Sdk sdk = rootManager.getSdk();
        final String oldVersionString = sdk.getVersionString();
        ((ProjectJdkImpl)sdk).setVersionString(testVersion.getDescription());
        assert (JavaSdk.getInstance().getVersion(sdk) == testVersion);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ((ProjectJdkImpl)sdk).setVersionString(oldVersionString);
            }
        });
    }

    @NotNull
    public static String requireRealJdkHome() {
        String javaHome = SystemProperties.getJavaHome();
        List paths = ContainerUtil.packNullables((Object[])new String[]{javaHome, new File(javaHome).getParent(), System.getenv("JDK_16_x64"), System.getenv("JDK_16")});
        for (String path2 : paths) {
            if (!JdkUtil.checkForJdk(new File(path2))) continue;
            return path2;
        }
        Assume.assumeTrue((String)("Cannot find JDK, checked paths: " + paths), (boolean)false);
        return null;
    }
}

