/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;

public class OverridingMethodsSearch
extends ExtensibleQueryFactory<PsiMethod, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.overridingMethodsSearch");
    public static final OverridingMethodsSearch INSTANCE = new OverridingMethodsSearch();

    private OverridingMethodsSearch() {
    }

    public static Query<PsiMethod> search(final PsiMethod method, SearchScope scope, boolean checkDeep) {
        if (ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            public Boolean compute() {
                return OverridingMethodsSearch.cannotBeOverriden(method);
            }
        }).booleanValue()) {
            return EmptyQuery.getEmptyQuery();
        }
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(method, scope, checkDeep));
    }

    private static boolean cannotBeOverriden(PsiMethod method) {
        PsiClass parentClass = method.getContainingClass();
        return parentClass == null || method.isConstructor() || method.hasModifierProperty("static") || method.hasModifierProperty("final") || method.hasModifierProperty("private") || parentClass instanceof PsiAnonymousClass || parentClass.hasModifierProperty("final");
    }

    public static Query<PsiMethod> search(final PsiMethod method, boolean checkDeep) {
        return OverridingMethodsSearch.search(method, ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

            public SearchScope compute() {
                return method.getUseScope();
            }
        }), checkDeep);
    }

    public static Query<PsiMethod> search(PsiMethod method) {
        return OverridingMethodsSearch.search(method, true);
    }

    public static class SearchParameters {
        private final PsiMethod myMethod;
        private final SearchScope myScope;
        private final boolean myCheckDeep;

        public SearchParameters(PsiMethod aClass, SearchScope scope, boolean checkDeep) {
            this.myMethod = aClass;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
        }

        public PsiMethod getMethod() {
            return this.myMethod;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        public SearchScope getScope() {
            return this.myScope;
        }
    }
}

