/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class ClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.classInheritorsSearch");
    public static final ClassInheritorsSearch INSTANCE = new ClassInheritorsSearch();

    private ClassInheritorsSearch() {
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
        return ClassInheritorsSearch.search(new SearchParameters(aClass, scope, checkDeep, checkInheritance, includeAnonymous));
    }

    public static Query<PsiClass> search(@NotNull SearchParameters parameters) {
        return INSTANCE.createUniqueResultsQuery(parameters, ContainerUtil.canonicalStrategy(), new Function<PsiClass, SmartPsiElementPointer<PsiClass>>(){

            public SmartPsiElementPointer<PsiClass> fun(final PsiClass psiClass) {
                return ApplicationManager.getApplication().runReadAction(new Computable<SmartPsiElementPointer<PsiClass>>(){

                    public SmartPsiElementPointer<PsiClass> compute() {
                        return SmartPointerManager.getInstance(psiClass.getProject()).createSmartPsiElementPointer(psiClass);
                    }
                });
            }
        });
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance) {
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, checkInheritance, true);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep) {
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, true);
    }

    public static Query<PsiClass> search(final @NotNull PsiClass aClass, boolean checkDeep) {
        return ClassInheritorsSearch.search(aClass, ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

            public SearchScope compute() {
                if (!aClass.isValid()) {
                    throw new ProcessCanceledException();
                }
                return aClass.getUseScope();
            }
        }), checkDeep);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass) {
        return ClassInheritorsSearch.search(aClass, true);
    }

    public static class SearchParameters {
        private final PsiClass myClass;
        private final SearchScope myScope;
        private final boolean myCheckDeep;
        private final boolean myCheckInheritance;
        private final boolean myIncludeAnonymous;
        private final Condition<String> myNameCondition;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
            this(aClass, scope, checkDeep, checkInheritance, includeAnonymous, (Condition<String>)Conditions.alwaysTrue());
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous, @NotNull Condition<String> nameCondition) {
            this.myClass = aClass;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
            this.myCheckInheritance = checkInheritance;
            this.myIncludeAnonymous = includeAnonymous;
            this.myNameCondition = nameCondition;
        }

        @NotNull
        public PsiClass getClassToProcess() {
            return this.myClass;
        }

        @NotNull
        public Condition<String> getNameCondition() {
            return this.myNameCondition;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean isCheckInheritance() {
            return this.myCheckInheritance;
        }

        public boolean isIncludeAnonymous() {
            return this.myIncludeAnonymous;
        }
    }
}

