/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchScopeUtil {
    @Nullable
    public static SearchScope union(@Nullable SearchScope a, @Nullable SearchScope b) {
        return a == null ? b : (b == null ? a : a.union(b));
    }

    @Deprecated
    @NotNull
    public static SearchScope scopesUnion(@NotNull SearchScope scope1, @NotNull SearchScope scope2) {
        return scope1.union(scope2);
    }

    public static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiElement element) {
        if (scope instanceof LocalSearchScope) {
            LocalSearchScope local = (LocalSearchScope)scope;
            return PsiSearchScopeUtil.isInScope(local, element);
        }
        GlobalSearchScope globalScope = (GlobalSearchScope)scope;
        return PsiSearchScopeUtil.isInScope(globalScope, element);
    }

    public static boolean isInScope(@NotNull GlobalSearchScope globalScope, @NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return true;
        }
        PsiElement context = file.getContext();
        if (context != null) {
            file = context.getContainingFile();
        }
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile == null || globalScope.contains(virtualFile);
    }

    public static boolean isInScope(@NotNull LocalSearchScope local, @NotNull PsiElement element) {
        PsiElement[] scopeElements;
        for (PsiElement scopeElement : scopeElements = local.getScope()) {
            if (!PsiTreeUtil.isAncestor(scopeElement, element, false)) continue;
            return true;
        }
        return false;
    }
}

