/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopesCore {
    @NotNull
    public static GlobalSearchScope projectProductionScope(@NotNull Project project) {
        return new ProductionScopeFilter(project);
    }

    @NotNull
    public static GlobalSearchScope projectTestScope(@NotNull Project project) {
        return new TestScopeFilter(project);
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
        return new DirectoryScope(directory, withSubdirectories);
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
        return new DirectoryScope(project, directory, withSubdirectories);
    }

    @NotNull
    public static GlobalSearchScope directoriesScope(@NotNull Project project, boolean withSubdirectories, VirtualFile ... directories) {
        if (directories.length == 1) {
            return GlobalSearchScopesCore.directoryScope(project, directories[0], withSubdirectories);
        }
        BitSet withSubdirectoriesBS = new BitSet(directories.length);
        if (withSubdirectories) {
            withSubdirectoriesBS.set(0, directories.length);
        }
        return new DirectoriesScope(project, directories, withSubdirectoriesBS);
    }

    public static GlobalSearchScope filterScope(@NotNull Project project, @NotNull NamedScope set) {
        return new FilterScopeAdapter(project, set);
    }

    static class DirectoriesScope
    extends GlobalSearchScope {
        private final VirtualFile[] myDirectories;
        private final BitSet myWithSubdirectories;

        private DirectoriesScope(@NotNull Project project, @NotNull VirtualFile[] directories, @NotNull BitSet withSubdirectories) {
            super(project);
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectories = directories;
            if (directories.length < 2) {
                throw new IllegalArgumentException("Expected >1 directories, but got: " + Arrays.asList(directories));
            }
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            VirtualFile parent = file.getParent();
            return parent != null && this.in(parent);
        }

        private boolean in(@NotNull VirtualFile parent) {
            for (int i = 0; i < this.myDirectories.length; ++i) {
                VirtualFile directory = this.myDirectories[i];
                boolean withSubdirectories = this.myWithSubdirectories.get(i);
                if (!(withSubdirectories ? VfsUtilCore.isAncestor(directory, parent, false) : directory.equals(parent))) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        public String toString() {
            return "Directories scope: " + Arrays.asList(this.myDirectories);
        }

        @Override
        public int hashCode() {
            int result = 1;
            for (int i = 0; i < this.myDirectories.length; ++i) {
                VirtualFile directory = this.myDirectories[i];
                boolean withSubdirectories = this.myWithSubdirectories.get(i);
                result = result * 31 + directory.hashCode() * 31 + (withSubdirectories ? 1 : 0);
            }
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoriesScope && Arrays.equals(this.myDirectories, ((DirectoriesScope)obj).myDirectories) && this.myWithSubdirectories.equals(((DirectoriesScope)obj).myWithSubdirectories);
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (this.equals(scope)) {
                return this;
            }
            if (scope instanceof DirectoryScope) {
                if (this.in(((DirectoryScope)scope).myDirectory)) {
                    return this;
                }
                VirtualFile[] newDirectories = (VirtualFile[])ArrayUtil.append((Object[])this.myDirectories, (Object)((DirectoryScope)scope).myDirectory, VirtualFile.class);
                BitSet newWithSubdirectories = (BitSet)this.myWithSubdirectories.clone();
                newWithSubdirectories.set(this.myDirectories.length, ((DirectoryScope)scope).myWithSubdirectories);
                return new DirectoriesScope(this.getProject(), newDirectories, newWithSubdirectories);
            }
            if (scope instanceof DirectoriesScope) {
                DirectoriesScope other = (DirectoriesScope)scope;
                ArrayList<VirtualFile> newDirectories = new ArrayList<VirtualFile>(this.myDirectories.length + other.myDirectories.length);
                newDirectories.addAll(Arrays.asList(other.myDirectories));
                BitSet newWithSubdirectories = (BitSet)this.myWithSubdirectories.clone();
                VirtualFile[] directories = other.myDirectories;
                for (int i = 0; i < directories.length; ++i) {
                    VirtualFile otherDirectory = directories[i];
                    if (this.in(otherDirectory)) continue;
                    newWithSubdirectories.set(newDirectories.size(), other.myWithSubdirectories.get(i));
                    newDirectories.add(otherDirectory);
                }
                return new DirectoriesScope(this.getProject(), newDirectories.toArray(new VirtualFile[newDirectories.size()]), newWithSubdirectories);
            }
            return super.uniteWith(scope);
        }

        @Override
        @NotNull
        public Project getProject() {
            return super.getProject();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myDirectories.length == 1) {
                VirtualFile root = this.myDirectories[0];
                return "Directory '" + root.getName() + "'";
            }
            return "Directories " + StringUtil.join((Object[])this.myDirectories, (Function)new Function<VirtualFile, String>(){

                public String fun(VirtualFile file) {
                    return "'" + file.getName() + "'";
                }
            }, (String)", ");
        }
    }

    private static class DirectoryScope
    extends GlobalSearchScope {
        private final VirtualFile myDirectory;
        private final boolean myWithSubdirectories;

        private DirectoryScope(@NotNull PsiDirectory psiDirectory, boolean withSubdirectories) {
            super(psiDirectory.getProject());
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = psiDirectory.getVirtualFile();
        }

        private DirectoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
            super(project);
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = directory;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            return this.myWithSubdirectories ? VfsUtilCore.isAncestor(this.myDirectory, file, false) : this.myDirectory.equals(file.getParent());
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        public String toString() {
            return "directory scope: " + this.myDirectory + "; withSubdirs:" + this.myWithSubdirectories;
        }

        @Override
        public int hashCode() {
            return this.myDirectory.hashCode() * 31 + (this.myWithSubdirectories ? 1 : 0);
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoryScope && this.myDirectory.equals(((DirectoryScope)obj).myDirectory) && this.myWithSubdirectories == ((DirectoryScope)obj).myWithSubdirectories;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (this.equals(scope)) {
                return this;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                VirtualFile otherDirectory = other.myDirectory;
                if (this.myWithSubdirectories && VfsUtilCore.isAncestor(this.myDirectory, otherDirectory, false)) {
                    return this;
                }
                if (other.myWithSubdirectories && VfsUtilCore.isAncestor(otherDirectory, this.myDirectory, false)) {
                    return other;
                }
                BitSet newWithSubdirectories = new BitSet();
                newWithSubdirectories.set(0, this.myWithSubdirectories);
                newWithSubdirectories.set(1, other.myWithSubdirectories);
                return new DirectoriesScope(this.getProject(), new VirtualFile[]{this.myDirectory, otherDirectory}, newWithSubdirectories);
            }
            return super.uniteWith(scope);
        }

        @Override
        @NotNull
        public Project getProject() {
            return super.getProject();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return "Directory '" + this.myDirectory.getName() + "'";
        }
    }

    private static class TestScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private TestScopeFilter(@NotNull Project project) {
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            return this.myFileIndex.isInTestSourceContent(file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            return testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return PsiBundle.message("psi.search.scope.test.files", new Object[0]);
        }
    }

    private static class ProductionScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private ProductionScopeFilter(@NotNull Project project) {
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            return this.myFileIndex.isInSourceContent(file) && !this.myFileIndex.isInTestSourceContent(file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            return !testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return PsiBundle.message("psi.search.scope.production.files", new Object[0]);
        }
    }

    private static class FilterScopeAdapter
    extends GlobalSearchScope {
        private final NamedScope mySet;
        private final PsiManager myManager;

        private FilterScopeAdapter(@NotNull Project project, @NotNull NamedScope set) {
            super(project);
            this.mySet = set;
            this.myManager = PsiManager.getInstance(project);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            Project project = this.getProject();
            NamedScopeManager holder = NamedScopeManager.getInstance(project);
            PackageSet packageSet = this.mySet.getValue();
            if (packageSet != null) {
                if (packageSet instanceof PackageSetBase) {
                    return ((PackageSetBase)packageSet).contains(file, project, holder);
                }
                PsiFile psiFile = this.myManager.findFile(file);
                return psiFile != null && packageSet.contains(psiFile, holder);
            }
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.mySet.getName();
        }

        @Override
        @NotNull
        public Project getProject() {
            return super.getProject();
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

