/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.ref;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiChildLink;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationChildLink
extends PsiChildLink<PsiModifierListOwner, PsiAnnotation> {
    private final String myAnnoFqn;

    public AnnotationChildLink(String fqn) {
        this.myAnnoFqn = fqn;
    }

    public String getAnnotationQualifiedName() {
        return this.myAnnoFqn;
    }

    public static PsiElementRef<PsiAnnotation> createRef(@NotNull PsiModifierListOwner parent, @NonNls String fqn) {
        return new AnnotationChildLink(fqn).createChildRef(parent);
    }

    @Override
    public PsiAnnotation findLinkedChild(@Nullable PsiModifierListOwner member) {
        if (member == null) {
            return null;
        }
        PsiModifierList modifierList = member.getModifierList();
        return modifierList != null ? modifierList.findAnnotation(this.myAnnoFqn) : null;
    }

    @Override
    @NotNull
    public PsiAnnotation createChild(@NotNull PsiModifierListOwner member) throws IncorrectOperationException {
        PsiModifierList modifierList = member.getModifierList();
        assert (modifierList != null);
        return modifierList.addAnnotation(this.myAnnoFqn);
    }

    public String toString() {
        return "AnnotationChildLink{myAnnoFqn='" + this.myAnnoFqn + '\'' + '}';
    }
}

