/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StdArrangementRuleAliasToken
extends StdArrangementSettingsToken
implements Cloneable {
    private String myName;
    private List<StdArrangementMatchRule> myDefinitionRules;

    public StdArrangementRuleAliasToken(@NotNull String name) {
        this(name, ContainerUtil.emptyList());
    }

    public StdArrangementRuleAliasToken(@NotNull String name, @NotNull List<StdArrangementMatchRule> definitionRules) {
        this(StdArrangementRuleAliasToken.createIdByName(name), name, definitionRules);
        this.myDefinitionRules = definitionRules;
    }

    public StdArrangementRuleAliasToken(@NotNull String id, @NotNull String name, @NotNull List<StdArrangementMatchRule> definitionRules) {
        super(id, StdArrangementRuleAliasToken.createRepresentationValue(name), StdArrangementTokenType.ALIAS);
        this.myName = name;
        this.myDefinitionRules = definitionRules;
    }

    @NotNull
    private static String createRepresentationValue(@NotNull String name) {
        return "by " + name;
    }

    private static String createIdByName(@NotNull String name) {
        return name.replaceAll("\\s+", "_");
    }

    public String getName() {
        return this.myName;
    }

    public List<StdArrangementMatchRule> getDefinitionRules() {
        return this.myDefinitionRules;
    }

    public void setDefinitionRules(List<StdArrangementMatchRule> definitionRules) {
        this.myDefinitionRules = definitionRules;
    }

    public void setTokenName(@NotNull String name) {
        this.myId = name.replaceAll("\\s+", "_");
        this.myRepresentationName = StdArrangementRuleAliasToken.createRepresentationValue(name);
        this.myName = name;
    }

    protected StdArrangementRuleAliasToken clone() {
        ArrayList<StdArrangementMatchRule> newValue = new ArrayList<StdArrangementMatchRule>(this.myDefinitionRules.size());
        for (StdArrangementMatchRule rule : this.myDefinitionRules) {
            newValue.add(rule.clone());
        }
        return new StdArrangementRuleAliasToken(this.getName(), newValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementRuleAliasToken token = (StdArrangementRuleAliasToken)o;
        if (!super.equals(o)) {
            return false;
        }
        return !(this.myDefinitionRules != null ? !this.myDefinitionRules.equals(token.myDefinitionRules) : token.myDefinitionRules != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myDefinitionRules != null ? this.myDefinitionRules.hashCode() : 0);
        return result;
    }
}

