/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.model;

import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.InvertibleArrangementSettingsToken;
import org.jetbrains.annotations.NotNull;

public class ArrangementAtomMatchCondition
implements ArrangementMatchCondition {
    @NotNull
    private final ArrangementSettingsToken myType;
    @NotNull
    private final Object myValue;

    public ArrangementAtomMatchCondition(@NotNull ArrangementSettingsToken type) {
        this(type, type instanceof InvertibleArrangementSettingsToken ? Boolean.TRUE : type);
    }

    public ArrangementAtomMatchCondition(@NotNull ArrangementSettingsToken type, @NotNull Object value) {
        this.myType = type;
        this.myValue = value;
    }

    @NotNull
    public ArrangementSettingsToken getType() {
        return this.myType;
    }

    @NotNull
    public Object getValue() {
        return this.myValue;
    }

    @Override
    public void invite(@NotNull ArrangementMatchConditionVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int result = this.myType.hashCode();
        result = 31 * result + this.myValue.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementAtomMatchCondition setting = (ArrangementAtomMatchCondition)o;
        if (!this.myType.equals(setting.myType)) {
            return false;
        }
        return this.myValue.equals(setting.myValue);
    }

    @Override
    @NotNull
    public ArrangementAtomMatchCondition clone() {
        return new ArrangementAtomMatchCondition(this.myType, this.myValue);
    }

    public String toString() {
        if (this.myValue instanceof Boolean) {
            return String.format("%s%s", (Boolean)this.myValue != false ? "" : "not ", this.myType.getRepresentationValue());
        }
        return String.format("%s: %s", this.myType.getRepresentationValue(), this.myValue.toString().toLowerCase());
    }
}

