/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionRule
implements Cloneable {
    @Nullable
    private final String myStartComment;
    @Nullable
    private final String myEndComment;
    private final List<StdArrangementMatchRule> myMatchRules;

    private ArrangementSectionRule(@Nullable String start, @Nullable String end, @NotNull List<StdArrangementMatchRule> rules) {
        this.myStartComment = start;
        this.myEndComment = end;
        this.myMatchRules = rules;
    }

    public List<StdArrangementMatchRule> getMatchRules() {
        return this.myMatchRules;
    }

    public static ArrangementSectionRule create(StdArrangementMatchRule ... rules) {
        return ArrangementSectionRule.create(null, null, rules);
    }

    public static ArrangementSectionRule create(@Nullable String start, @Nullable String end, StdArrangementMatchRule ... rules) {
        return ArrangementSectionRule.create(start, end, rules.length == 0 ? ContainerUtil.emptyList() : ContainerUtil.newArrayList((Object[])rules));
    }

    public static ArrangementSectionRule create(@Nullable String start, @Nullable String end, @NotNull List<StdArrangementMatchRule> rules) {
        ArrayList matchRules = ContainerUtil.newArrayList();
        if (StringUtil.isNotEmpty((String)start)) {
            matchRules.add(ArrangementSectionRule.createSectionRule(start, StdArrangementTokens.Section.START_SECTION));
        }
        matchRules.addAll(rules);
        if (StringUtil.isNotEmpty((String)end)) {
            matchRules.add(ArrangementSectionRule.createSectionRule(end, StdArrangementTokens.Section.END_SECTION));
        }
        return new ArrangementSectionRule(start, end, matchRules);
    }

    @NotNull
    private static StdArrangementMatchRule createSectionRule(@NotNull String comment, @NotNull ArrangementSettingsToken token) {
        ArrangementAtomMatchCondition text = new ArrangementAtomMatchCondition(StdArrangementTokens.Regexp.TEXT, comment);
        ArrangementMatchCondition condition = ArrangementUtil.combine(new ArrangementAtomMatchCondition(token), text);
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher(condition));
    }

    @Nullable
    public String getStartComment() {
        return this.myStartComment;
    }

    @Nullable
    public String getEndComment() {
        return this.myEndComment;
    }

    public int hashCode() {
        int factor = 31;
        int hash = StringUtil.notNullize((String)this.myStartComment).hashCode() + factor * StringUtil.notNullize((String)this.myEndComment).hashCode();
        for (StdArrangementMatchRule rule : this.myMatchRules) {
            factor *= factor;
            hash += rule.hashCode() * factor;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementSectionRule section = (ArrangementSectionRule)o;
        if (!StringUtil.equals((CharSequence)this.myStartComment, (CharSequence)section.myStartComment) || !StringUtil.equals((CharSequence)this.myEndComment, (CharSequence)section.myEndComment) || this.myMatchRules.size() != section.getMatchRules().size()) {
            return false;
        }
        List<StdArrangementMatchRule> matchRules = section.getMatchRules();
        for (int i = 0; i < this.myMatchRules.size(); ++i) {
            StdArrangementMatchRule rule2;
            StdArrangementMatchRule rule1 = this.myMatchRules.get(i);
            if (rule1.equals(rule2 = matchRules.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (StringUtil.isEmpty((String)this.myStartComment)) {
            return "Section: [" + StringUtil.join(this.myMatchRules, (String)",") + "]";
        }
        return "Section (" + this.myStartComment + (StringUtil.isEmpty((String)this.myEndComment) ? "" : ", " + this.myEndComment) + ")";
    }

    public ArrangementSectionRule clone() {
        ArrayList rules = ContainerUtil.newArrayList();
        for (StdArrangementMatchRule myMatchRule : this.myMatchRules) {
            rules.add(myMatchRule.clone());
        }
        return new ArrangementSectionRule(this.myStartComment, this.myEndComment, rules);
    }
}

