/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonCodeStyleSettingsManager
implements JDOMExternalizable {
    private volatile Map<Language, CommonCodeStyleSettings> myCommonSettingsMap;
    private volatile Map<String, Content> myUnknownSettingsMap;
    @NotNull
    private final CodeStyleSettings myParentSettings;
    @NonNls
    private static final String COMMON_SETTINGS_TAG = "codeStyleSettings";
    private static final String LANGUAGE_ATTR = "language";

    CommonCodeStyleSettingsManager(@NotNull CodeStyleSettings parentSettings) {
        this.myParentSettings = parentSettings;
    }

    public CommonCodeStyleSettings getCommonSettings(@Nullable Language lang) {
        Map<Language, CommonCodeStyleSettings> commonSettingsMap = this.getCommonSettingsMap();
        CommonCodeStyleSettings settings = commonSettingsMap.get((Object)lang);
        while (settings == null && lang != null) {
            lang = lang.getBaseLanguage();
            settings = commonSettingsMap.get((Object)lang);
        }
        if (settings != null) {
            return settings;
        }
        return this.myParentSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Language, CommonCodeStyleSettings> getCommonSettingsMap() {
        Map<Language, CommonCodeStyleSettings> commonSettingsMap = this.myCommonSettingsMap;
        if (commonSettingsMap == null) {
            CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
            synchronized (commonCodeStyleSettingsManager) {
                commonSettingsMap = this.myCommonSettingsMap;
                if (commonSettingsMap == null) {
                    commonSettingsMap = this.initCommonSettingsMap();
                    this.initNonReadSettings();
                }
            }
        }
        return commonSettingsMap;
    }

    @NotNull
    public CommonCodeStyleSettings getCommonSettings(@NotNull String langName) {
        Map<Language, CommonCodeStyleSettings> map = this.getCommonSettingsMap();
        for (Map.Entry<Language, CommonCodeStyleSettings> entry : map.entrySet()) {
            if (!langName.equals(entry.getKey().getDisplayName())) continue;
            return entry.getValue();
        }
        return this.myParentSettings;
    }

    private void initNonReadSettings() {
        LanguageCodeStyleSettingsProvider[] providers;
        for (LanguageCodeStyleSettingsProvider provider : providers = (LanguageCodeStyleSettingsProvider[])Extensions.getExtensions(LanguageCodeStyleSettingsProvider.EP_NAME)) {
            CommonCodeStyleSettings initialSettings;
            Language target = provider.getLanguage();
            if (this.myCommonSettingsMap.containsKey((Object)target) || (initialSettings = provider.getDefaultCommonSettings()) == null) continue;
            this.init(initialSettings, target);
        }
    }

    private void init(@NotNull CommonCodeStyleSettings initialSettings, @NotNull Language target) {
        initialSettings.setRootSettings(this.myParentSettings);
        this.registerCommonSettings(target, initialSettings);
    }

    private Map<Language, CommonCodeStyleSettings> initCommonSettingsMap() {
        LinkedHashMap<Language, CommonCodeStyleSettings> map = new LinkedHashMap<Language, CommonCodeStyleSettings>();
        this.myCommonSettingsMap = map;
        this.myUnknownSettingsMap = new LinkedHashMap<String, Content>();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCommonSettings(@NotNull Language lang, @NotNull CommonCodeStyleSettings settings) {
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            if (!this.myCommonSettingsMap.containsKey((Object)lang)) {
                this.myCommonSettingsMap.put(lang, settings);
                settings.getRootSettings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CommonCodeStyleSettingsManager clone(@NotNull CodeStyleSettings parentSettings) {
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            CommonCodeStyleSettingsManager settingsManager = new CommonCodeStyleSettingsManager(parentSettings);
            if (this.myCommonSettingsMap != null && !this.myCommonSettingsMap.isEmpty()) {
                settingsManager.initCommonSettingsMap();
                for (Map.Entry<Language, CommonCodeStyleSettings> entry : this.myCommonSettingsMap.entrySet()) {
                    CommonCodeStyleSettings clonedSettings = entry.getValue().clone(parentSettings);
                    settingsManager.registerCommonSettings(entry.getKey(), clonedSettings);
                }
            }
            return settingsManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            this.initCommonSettingsMap();
            List list = element.getChildren(COMMON_SETTINGS_TAG);
            for (Object o : list) {
                boolean isKnownLanguage;
                Element commonSettingsElement = (Element)o;
                String languageId = commonSettingsElement.getAttributeValue(LANGUAGE_ATTR);
                if (languageId == null || languageId.isEmpty()) continue;
                Language target = Language.findLanguageByID(languageId);
                boolean bl = isKnownLanguage = target != null;
                if (isKnownLanguage) {
                    LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(target);
                    if (provider != null) {
                        CommonCodeStyleSettings settings = provider.getDefaultCommonSettings();
                        if (settings != null) {
                            settings.readExternal(commonSettingsElement);
                            this.init(settings, target);
                        }
                    } else {
                        isKnownLanguage = false;
                    }
                }
                if (isKnownLanguage) continue;
                this.myUnknownSettingsMap.put(languageId, (Content)commonSettingsElement.clone());
            }
            this.initNonReadSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            if (this.myCommonSettingsMap == null) {
                return;
            }
            HashMap id2lang = new HashMap();
            for (Language language : this.myCommonSettingsMap.keySet()) {
                id2lang.put(language.getID(), language);
            }
            HashSet<String> langIdList = new HashSet<String>();
            langIdList.addAll(this.myUnknownSettingsMap.keySet());
            langIdList.addAll(id2lang.keySet());
            String[] languages = ArrayUtil.toStringArray(langIdList);
            Arrays.sort(languages, new Comparator<String>(){

                @Override
                public int compare(@NotNull String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            for (String id : languages) {
                Language language = (Language)((Object)id2lang.get(id));
                if (language != null) {
                    CommonCodeStyleSettings commonSettings = this.myCommonSettingsMap.get((Object)language);
                    Element commonSettingsElement = new Element(COMMON_SETTINGS_TAG);
                    commonSettings.writeExternal(commonSettingsElement);
                    commonSettingsElement.setAttribute(LANGUAGE_ATTR, language.getID());
                    if (commonSettingsElement.getChildren().isEmpty()) continue;
                    element.addContent(commonSettingsElement);
                    continue;
                }
                Content unknown = this.myUnknownSettingsMap.get(id);
                if (unknown == null) continue;
                element.addContent(unknown.detach());
            }
        }
    }

    public static void copy(@NotNull CommonCodeStyleSettings source, @NotNull CommonCodeStyleSettings target) {
        CommonCodeStyleSettings.IndentOptions sourceIndentOptions;
        CommonCodeStyleSettings.copyPublicFields(source, target);
        CommonCodeStyleSettings.IndentOptions targetIndentOptions = target.getIndentOptions();
        if (targetIndentOptions != null && (sourceIndentOptions = source.getIndentOptions()) != null) {
            CommonCodeStyleSettings.copyPublicFields(sourceIndentOptions, targetIndentOptions);
        }
    }
}

