/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiType
implements PsiAnnotationOwner {
    public static final PsiPrimitiveType BYTE = new PsiPrimitiveType("byte", "java.lang.Byte");
    public static final PsiPrimitiveType CHAR = new PsiPrimitiveType("char", "java.lang.Character");
    public static final PsiPrimitiveType DOUBLE = new PsiPrimitiveType("double", "java.lang.Double");
    public static final PsiPrimitiveType FLOAT = new PsiPrimitiveType("float", "java.lang.Float");
    public static final PsiPrimitiveType INT = new PsiPrimitiveType("int", "java.lang.Integer");
    public static final PsiPrimitiveType LONG = new PsiPrimitiveType("long", "java.lang.Long");
    public static final PsiPrimitiveType SHORT = new PsiPrimitiveType("short", "java.lang.Short");
    public static final PsiPrimitiveType BOOLEAN = new PsiPrimitiveType("boolean", "java.lang.Boolean");
    public static final PsiPrimitiveType VOID = new PsiPrimitiveType("void", "java.lang.Void");
    public static final PsiPrimitiveType NULL = new PsiPrimitiveType("null", (String)null);
    public static final PsiType[] EMPTY_ARRAY = new PsiType[0];
    public static final ArrayFactory<PsiType> ARRAY_FACTORY = new ArrayFactory<PsiType>(){

        @NotNull
        public PsiType[] create(int count) {
            return count == 0 ? EMPTY_ARRAY : new PsiType[count];
        }
    };
    private final TypeAnnotationProvider myAnnotationProvider;

    @NotNull
    public static PsiType[] createArray(int count) {
        return (PsiType[])ARRAY_FACTORY.create(count);
    }

    protected PsiType(final @NotNull PsiAnnotation[] annotations) {
        this(annotations.length == 0 ? TypeAnnotationProvider.EMPTY : new TypeAnnotationProvider(){

            @Override
            @NotNull
            public PsiAnnotation[] getAnnotations() {
                return annotations;
            }
        });
    }

    protected PsiType(@NotNull TypeAnnotationProvider annotations) {
        this.myAnnotationProvider = annotations;
    }

    @NotNull
    public PsiArrayType createArrayType() {
        return new PsiArrayType(this);
    }

    @NotNull
    public PsiArrayType createArrayType(PsiAnnotation ... annotations) {
        return new PsiArrayType(this, annotations);
    }

    @NonNls
    @NotNull
    public abstract String getPresentableText();

    @NonNls
    @NotNull
    public String getCanonicalText(boolean annotated) {
        return this.getCanonicalText();
    }

    @NonNls
    @NotNull
    public abstract String getCanonicalText();

    @NonNls
    @NotNull
    public abstract String getInternalCanonicalText();

    public abstract boolean isValid();

    public boolean isAssignableFrom(@NotNull PsiType type) {
        return TypeConversionUtil.isAssignable(this, type);
    }

    public boolean isConvertibleFrom(@NotNull PsiType type) {
        return TypeConversionUtil.areTypesConvertible(type, this);
    }

    public abstract boolean equalsToText(@NotNull @NonNls String var1);

    public static PsiClassType getTypeByName(String qName, Project project, GlobalSearchScope resolveScope) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(project).getElementFactory();
        return factory.createTypeByFQClassName(qName, resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangObject(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.Object", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangClass(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.Class", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangThrowable(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.Throwable", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangString(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.String", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangError(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.Error", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangRuntimeException(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.RuntimeException", manager.getProject(), resolveScope);
    }

    public abstract <A> A accept(@NotNull PsiTypeVisitor<A> var1);

    public final int getArrayDimensions() {
        PsiType type = this;
        int dims = 0;
        while (type instanceof PsiArrayType) {
            ++dims;
            type = ((PsiArrayType)type).getComponentType();
        }
        return dims;
    }

    @NotNull
    public final PsiType getDeepComponentType() {
        PsiType type = this;
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        return type;
    }

    @Nullable
    public abstract GlobalSearchScope getResolveScope();

    @NotNull
    public abstract PsiType[] getSuperTypes();

    @NotNull
    public final TypeAnnotationProvider getAnnotationProvider() {
        return this.myAnnotationProvider;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        return this.myAnnotationProvider.getAnnotations();
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (!qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        return this.getAnnotations();
    }

    public String toString() {
        return "PsiType:" + this.getPresentableText();
    }

    protected static abstract class Stub
    extends PsiType {
        protected Stub(@NotNull PsiAnnotation[] annotations) {
            super(annotations);
        }

        public Stub(@NotNull TypeAnnotationProvider annotations) {
            super(annotations);
        }

        @Override
        @NotNull
        public final String getCanonicalText() {
            return this.getCanonicalText(false);
        }

        @Override
        @NotNull
        public abstract String getCanonicalText(boolean var1);
    }
}

