/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ExceptionUtil;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiInvalidElementAccessException
extends RuntimeException
implements ExceptionWithAttachments {
    private static final Key<Object> INVALIDATION_TRACE = Key.create((String)"INVALIDATION_TRACE");
    private static final Key<Boolean> REPORTING_EXCEPTION = Key.create((String)"REPORTING_EXCEPTION");
    private final SoftReference<PsiElement> myElementReference;
    private final Attachment[] myDiagnostic;
    private final String myMessage;

    public PsiInvalidElementAccessException(@Nullable PsiElement element) {
        this(element, null, null);
    }

    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable String message) {
        this(element, message, null);
    }

    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable Throwable cause) {
        this(element, null, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable String message, @Nullable Throwable cause) {
        super(null, cause);
        this.myElementReference = new SoftReference<PsiElement>(element);
        if (element == null) {
            this.myMessage = message;
            this.myDiagnostic = Attachment.EMPTY_ARRAY;
        } else if (element == PsiUtilCore.NULL_PSI_ELEMENT) {
            this.myMessage = "NULL_PSI_ELEMENT ;" + message;
            this.myDiagnostic = Attachment.EMPTY_ARRAY;
        } else {
            boolean recursiveInvocation = Boolean.TRUE.equals(element.getUserData(REPORTING_EXCEPTION));
            element.putUserData(REPORTING_EXCEPTION, Boolean.TRUE);
            try {
                Object trace = recursiveInvocation ? null : PsiInvalidElementAccessException.findInvalidationTrace(element.getNode());
                this.myMessage = PsiInvalidElementAccessException.getMessageWithReason(element, message, recursiveInvocation, trace);
                if (trace == null) {
                    this.myDiagnostic = Attachment.EMPTY_ARRAY;
                } else {
                    String diagnostic = trace instanceof Throwable ? ExceptionUtil.getThrowableText((Throwable)((Throwable)trace)) : trace.toString();
                    this.myDiagnostic = new Attachment[]{new Attachment("diagnostic.txt", diagnostic)};
                }
            }
            finally {
                element.putUserData(REPORTING_EXCEPTION, null);
            }
        }
    }

    private static String getMessageWithReason(@NotNull PsiElement element, @Nullable String message, boolean recursiveInvocation, @Nullable Object trace) {
        String reason = "Element: " + element.getClass();
        if (!recursiveInvocation) {
            String traceText = !PsiInvalidElementAccessException.isTrackingInvalidation() ? "disabled" : (trace != null ? "see attachment" : "no info");
            reason = reason + " because: " + PsiInvalidElementAccessException.reason(element) + "\ninvalidated at: " + traceText;
        }
        return reason + (message == null ? "" : "; " + message);
    }

    @Override
    public String getMessage() {
        return this.myMessage;
    }

    @NotNull
    public Attachment[] getAttachments() {
        return this.myDiagnostic;
    }

    public static Object findInvalidationTrace(@Nullable ASTNode element) {
        while (element != null) {
            Object trace = element.getUserData(INVALIDATION_TRACE);
            if (trace != null) {
                return trace;
            }
            ASTNode parent = element.getTreeParent();
            if (parent == null && element instanceof FileASTNode) {
                PsiElement psi = element.getPsi();
                Object object = trace = psi == null ? null : psi.getUserData(INVALIDATION_TRACE);
                if (trace != null) {
                    return trace;
                }
            }
            element = parent;
        }
        return null;
    }

    @NonNls
    @NotNull
    private static String reason(@NotNull PsiElement root) {
        PsiElement context;
        PsiElement element;
        if (root == PsiUtilCore.NULL_PSI_ELEMENT) {
            return "NULL_PSI_ELEMENT";
        }
        PsiElement psiElement = element = root instanceof PsiFile ? root : root.getParent();
        if (element == null) {
            String m = "parent is null";
            if (root instanceof StubBasedPsiElement) {
                for (Object stub = ((StubBasedPsiElement)root).getStub(); stub != null; stub = stub.getParentStub()) {
                    m = m + "\n  each stub=" + stub;
                    if (!(stub instanceof PsiFileStub)) continue;
                    m = m + "; fileStub.psi=" + stub.getPsi() + "; reason=" + ((PsiFileStub)stub).getInvalidationReason();
                }
            }
            return m;
        }
        while (element != null && !(element instanceof PsiFile)) {
            element = element.getParent();
        }
        PsiFile file = (PsiFile)element;
        if (file == null) {
            return "containing file is null";
        }
        FileViewProvider provider = file.getViewProvider();
        VirtualFile vFile = provider.getVirtualFile();
        if (!vFile.isValid()) {
            return vFile + " is invalid";
        }
        if (!provider.isPhysical() && (context = file.getContext()) != null && !context.isValid()) {
            return "invalid context: " + PsiInvalidElementAccessException.reason(context);
        }
        PsiManager manager = file.getManager();
        if (manager.getProject().isDisposed()) {
            return "project is disposed";
        }
        Language language = file.getLanguage();
        if (language != provider.getBaseLanguage()) {
            return "File language:" + (Object)((Object)language) + " != Provider base language:" + (Object)((Object)provider.getBaseLanguage());
        }
        FileViewProvider p = manager.findViewProvider(vFile);
        if (provider != p) {
            return "different providers: " + provider + "(" + PsiInvalidElementAccessException.id(provider) + "); " + p + "(" + PsiInvalidElementAccessException.id(p) + ")";
        }
        if (!provider.isPhysical()) {
            return "non-physical provider: " + provider;
        }
        return "psi is outdated";
    }

    private static String id(FileViewProvider provider) {
        return Integer.toHexString(System.identityHashCode(provider));
    }

    public static void setInvalidationTrace(@NotNull UserDataHolder element, Object trace) {
        element.putUserData(INVALIDATION_TRACE, trace);
    }

    public static Object getInvalidationTrace(@NotNull UserDataHolder element) {
        return element.getUserData(INVALIDATION_TRACE);
    }

    public static boolean isTrackingInvalidation() {
        return Registry.is((String)"psi.track.invalidation");
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myElementReference.get();
    }
}

