/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRefElementCreator;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiElementRef<T extends PsiElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.PsiElementRef");
    private volatile PsiRefColleague<T> myColleague;

    public PsiElementRef(PsiRefColleague<T> colleague) {
        this.myColleague = colleague;
    }

    public final boolean isImaginary() {
        return this.getPsiElement() == null;
    }

    @Nullable
    public final T getPsiElement() {
        return this.myColleague.getPsiElement();
    }

    @NotNull
    public final T ensurePsiElementExists() {
        PsiRefColleague.Real<T> realColleague = this.myColleague.makeReal();
        this.myColleague = realColleague;
        return realColleague.getPsiElement();
    }

    @NotNull
    public final PsiElement getRoot() {
        return this.myColleague.getRoot();
    }

    public boolean equals(Object o) {
        return o instanceof PsiElementRef && this.myColleague.equals(((PsiElementRef)o).myColleague);
    }

    public int hashCode() {
        return this.myColleague.hashCode();
    }

    public final boolean isValid() {
        return this.myColleague.isValid();
    }

    public static <T extends PsiElement> PsiElementRef<T> real(@NotNull T element) {
        return new PsiElementRef<T>(new PsiRefColleague.Real<T>(element));
    }

    public static <Child extends PsiElement, Parent extends PsiElement> PsiElementRef<Child> imaginary(PsiElementRef<? extends Parent> parent, PsiRefElementCreator<Parent, Child> creator) {
        return new PsiElementRef(new PsiRefColleague.Imaginary<Child, Parent>(parent, creator));
    }

    public PsiManager getPsiManager() {
        return this.myColleague.getRoot().getManager();
    }

    private static interface PsiRefColleague<T extends PsiElement> {
        public boolean isValid();

        @Nullable
        public T getPsiElement();

        @NotNull
        public Real<T> makeReal();

        @NotNull
        public PsiElement getRoot();

        public static class Imaginary<Child extends PsiElement, Parent extends PsiElement>
        implements PsiRefColleague<Child> {
            private final PsiElementRef<? extends Parent> myParent;
            private final PsiRefElementCreator<Parent, Child> myCreator;

            public Imaginary(PsiElementRef<? extends Parent> parent, PsiRefElementCreator<Parent, Child> creator) {
                this.myParent = parent;
                this.myCreator = creator;
            }

            @Override
            public boolean isValid() {
                return this.myParent.isValid();
            }

            @Override
            public Child getPsiElement() {
                return null;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Imaginary imaginary = (Imaginary)o;
                if (!this.myCreator.equals(imaginary.myCreator)) {
                    return false;
                }
                return this.myParent.equals(imaginary.myParent);
            }

            public int hashCode() {
                int result = this.myParent.hashCode();
                result = 31 * result + this.myCreator.hashCode();
                return result;
            }

            @Override
            @NotNull
            public Real<Child> makeReal() {
                return new Real<PsiElement>((PsiElement)this.myCreator.createChild(this.myParent.ensurePsiElementExists()));
            }

            @Override
            @NotNull
            public PsiElement getRoot() {
                return this.myParent.getRoot();
            }
        }

        public static class Real<T extends PsiElement>
        implements PsiRefColleague<T> {
            private final T myElement;

            public Real(@NotNull T element) {
                PsiUtilCore.ensureValid(element);
                this.myElement = element;
            }

            @Override
            @NotNull
            public T getPsiElement() {
                return this.myElement;
            }

            @Override
            public boolean isValid() {
                return this.myElement.isValid();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Real real = (Real)o;
                return this.myElement.equals(real.myElement);
            }

            public int hashCode() {
                return this.myElement.hashCode();
            }

            @Override
            @NotNull
            public Real<T> makeReal() {
                return this;
            }

            @Override
            @NotNull
            public PsiElement getRoot() {
                return this.myElement;
            }
        }
    }
}

