/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCapturedWildcardType
extends PsiType.Stub {
    @NotNull
    private final PsiWildcardType myExistential;
    @NotNull
    private final PsiElement myContext;
    @Nullable
    private final PsiTypeParameter myParameter;
    private PsiType myUpperBound;
    public static RecursionGuard guard = RecursionManager.createGuard((String)"captureGuard");

    @NotNull
    public static PsiCapturedWildcardType create(@NotNull PsiWildcardType existential, @NotNull PsiElement context) {
        return PsiCapturedWildcardType.create(existential, context, null);
    }

    @NotNull
    public static PsiCapturedWildcardType create(@NotNull PsiWildcardType existential, @NotNull PsiElement context, @Nullable PsiTypeParameter parameter) {
        return new PsiCapturedWildcardType(existential, context, parameter);
    }

    private PsiCapturedWildcardType(@NotNull PsiWildcardType existential, @NotNull PsiElement context, @Nullable PsiTypeParameter parameter) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myExistential = existential;
        this.myContext = context;
        this.myParameter = parameter;
        this.myUpperBound = PsiType.getJavaLangObject(this.myContext.getManager(), this.getResolveScope());
    }

    public static boolean isCapture() {
        return guard.currentStack().isEmpty();
    }

    @Nullable
    public static PsiType captureUpperBound(@NotNull PsiTypeParameter typeParameter, @NotNull PsiWildcardType wildcardType, @NotNull PsiSubstitutor captureSubstitutor) {
        PsiType originalBound;
        PsiClassType[] boundTypes = typeParameter.getExtendsListTypes();
        PsiType glb = originalBound = !wildcardType.isSuper() ? wildcardType.getBound() : null;
        for (PsiClassType boundType : boundTypes) {
            PsiType substitutedBoundType = captureSubstitutor.substitute(boundType);
            if (originalBound instanceof PsiArrayType && substitutedBoundType instanceof PsiArrayType && !originalBound.isAssignableFrom(substitutedBoundType) && !substitutedBoundType.isAssignableFrom(originalBound)) continue;
            glb = glb == null ? substitutedBoundType : GenericsUtil.getGreatestLowerBound(glb, substitutedBoundType);
        }
        return glb;
    }

    public boolean equals(Object o) {
        Boolean sameUpperBounds;
        if (!(o instanceof PsiCapturedWildcardType)) {
            return false;
        }
        final PsiCapturedWildcardType captured = (PsiCapturedWildcardType)o;
        PsiManager manager = this.myContext.getManager();
        if (!manager.areElementsEquivalent(this.myContext, captured.myContext)) {
            return false;
        }
        if ((this.myExistential.isSuper() || captured.myExistential.isSuper()) && !this.myExistential.equals(captured.myExistential)) {
            return false;
        }
        if ((this.myContext instanceof PsiReferenceExpression || this.myContext instanceof PsiMethodCallExpression) && !manager.areElementsEquivalent(this.myParameter, captured.myParameter)) {
            return false;
        }
        if (this.myParameter != null && ((sameUpperBounds = (Boolean)guard.doPreventingRecursion((Object)this.myContext, true, (Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return Comparing.equal((Object)PsiCapturedWildcardType.this.myUpperBound, (Object)captured.myUpperBound);
            }
        })) == null || sameUpperBounds.booleanValue())) {
            return true;
        }
        return this.myExistential.equals(captured.myExistential);
    }

    public int hashCode() {
        return this.myUpperBound.hashCode() + 31 * this.myContext.hashCode();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return "capture of " + this.myExistential.getPresentableText();
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        return this.myExistential.getCanonicalText(annotated);
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        return "capture<" + this.myExistential.getInternalCanonicalText() + '>';
    }

    @Override
    public boolean isValid() {
        return this.myExistential.isValid() && this.myContext.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        return false;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        return visitor.visitCapturedWildcardType(this);
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        return this.myExistential.getResolveScope();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        return this.myExistential.getSuperTypes();
    }

    public PsiType getLowerBound() {
        return this.myExistential.isSuper() ? this.myExistential.getBound() : NULL;
    }

    @NotNull
    public PsiType getUpperBound() {
        PsiType bound = this.myExistential.getBound();
        if (this.myExistential.isExtends() && this.myParameter == null) {
            assert (bound != null) : this.myExistential.getCanonicalText();
            return bound;
        }
        return this.myUpperBound;
    }

    public void setUpperBound(@NotNull PsiType upperBound) {
        this.myUpperBound = upperBound;
    }

    @NotNull
    public PsiWildcardType getWildcard() {
        return this.myExistential;
    }

    @NotNull
    public PsiElement getContext() {
        return this.myContext;
    }

    public PsiTypeParameter getTypeParameter() {
        return this.myParameter;
    }
}

