/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ApplicationProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.ProjectProfileManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.OptionTag;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultProjectProfileManager
extends ProjectProfileManager
implements PersistentStateComponent<Element> {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.profile.DefaultProjectProfileManager");
    @NonNls
    public static final String SCOPES = "scopes";
    @NonNls
    protected static final String SCOPE = "scope";
    @NonNls
    public static final String PROFILE = "profile";
    @NonNls
    protected static final String NAME = "name";
    private static final String VERSION = "1.0";
    @NotNull
    protected final Project myProject;
    private String myProjectProfile;
    @OptionTag(value="USE_PROJECT_PROFILE")
    private boolean useProjectProfile = true;
    private final ApplicationProfileManager myApplicationProfileManager;
    private final Map<String, Profile> myProfiles = new THashMap();
    protected final DependencyValidationManager myHolder;
    private final List<ProfileChangeAdapter> myProfilesListener = ContainerUtil.createLockFreeCopyOnWriteList();
    @NonNls
    private static final String PROJECT_DEFAULT_PROFILE_NAME = "Project Default";

    public DefaultProjectProfileManager(@NotNull Project project, @NotNull ApplicationProfileManager applicationProfileManager, @NotNull DependencyValidationManager holder) {
        this.myProject = project;
        this.myHolder = holder;
        this.myApplicationProfileManager = applicationProfileManager;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public synchronized Profile getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        return this.myProfiles.containsKey(name) ? this.myProfiles.get(name) : this.myApplicationProfileManager.getProfile(name, returnRootProfileIfNamedIsAbsent);
    }

    @Override
    public synchronized void updateProfile(@NotNull Profile profile) {
        this.myProfiles.put(profile.getName(), profile);
        for (ProfileChangeAdapter profileChangeAdapter : this.myProfilesListener) {
            profileChangeAdapter.profileChanged(profile);
        }
    }

    @Override
    @Nullable
    public synchronized Element getState() {
        Element state = new Element("settings");
        Object[] sortedProfiles = this.myProfiles.keySet().toArray(new String[this.myProfiles.size()]);
        Arrays.sort(sortedProfiles);
        for (Object profile : sortedProfiles) {
            boolean hasSmthToSave;
            Profile projectProfile = this.myProfiles.get(profile);
            if (projectProfile == null) continue;
            Element profileElement = new Element(PROFILE);
            projectProfile.writeExternal(profileElement);
            boolean bl = hasSmthToSave = sortedProfiles.length > 1 || this.isCustomProfileUsed();
            if (!hasSmthToSave) {
                for (Element child : profileElement.getChildren()) {
                    if (child.getName().equals("option")) continue;
                    hasSmthToSave = true;
                    break;
                }
            }
            if (!hasSmthToSave) continue;
            state.addContent(profileElement);
        }
        if (!state.getChildren().isEmpty() || this.isCustomProfileUsed()) {
            XmlSerializer.serializeInto((Object)this, (Element)state);
            state.addContent(new Element("version").setAttribute("value", VERSION));
        }
        return state;
    }

    @Override
    public synchronized void loadState(Element state) {
        HashSet<String> profileKeys = new HashSet<String>();
        profileKeys.addAll(this.myProfiles.keySet());
        this.myProfiles.clear();
        XmlSerializer.deserializeInto((Object)this, (Element)state);
        for (Element o : state.getChildren(PROFILE)) {
            Profile profile = this.myApplicationProfileManager.createProfile();
            profile.setProfileManager(this);
            profile.readExternal(o);
            profile.setProjectLevel(true);
            if (profileKeys.contains(profile.getName())) {
                this.updateProfile(profile);
                continue;
            }
            this.myProfiles.put(profile.getName(), profile);
        }
        if (state.getChild("version") == null || !Comparing.strEqual((String)state.getChild("version").getAttributeValue("value"), (String)VERSION)) {
            boolean toConvert = true;
            for (Element o : state.getChildren("option")) {
                if (!Comparing.strEqual((String)o.getAttributeValue(NAME), (String)"USE_PROJECT_LEVEL_SETTINGS")) continue;
                toConvert = Boolean.parseBoolean(o.getAttributeValue("value"));
                break;
            }
            if (toConvert) {
                this.convert(state);
            }
        }
    }

    protected void convert(Element element) {
    }

    private boolean isCustomProfileUsed() {
        return this.myProjectProfile != null && !Comparing.strEqual((String)this.myProjectProfile, (String)PROJECT_DEFAULT_PROFILE_NAME);
    }

    @Override
    @NotNull
    public NamedScopesHolder getScopesManager() {
        return this.myHolder;
    }

    @Override
    @NotNull
    public synchronized Collection<Profile> getProfiles() {
        this.getProjectProfileImpl();
        return this.myProfiles.values();
    }

    @Override
    @NotNull
    public synchronized String[] getAvailableProfileNames() {
        return ArrayUtil.toStringArray(this.myProfiles.keySet());
    }

    @Override
    public synchronized void deleteProfile(@NotNull String name) {
        this.myProfiles.remove(name);
    }

    @Override
    @OptionTag(value="PROJECT_PROFILE")
    public synchronized String getProjectProfile() {
        return this.myProjectProfile;
    }

    @Override
    public synchronized void setProjectProfile(@Nullable String newProfile) {
        if (Comparing.strEqual((String)newProfile, (String)this.myProjectProfile)) {
            return;
        }
        String oldProfile = this.myProjectProfile;
        this.myProjectProfile = newProfile;
        boolean bl = this.useProjectProfile = newProfile != null;
        if (oldProfile != null) {
            for (ProfileChangeAdapter adapter : this.myProfilesListener) {
                adapter.profileActivated(this.getProfile(oldProfile), newProfile != null ? this.getProfile(newProfile) : null);
            }
        }
    }

    @NotNull
    public synchronized Profile getProjectProfileImpl() {
        if (!this.useProjectProfile) {
            return this.myApplicationProfileManager.getRootProfile();
        }
        if (this.myProjectProfile == null || this.myProfiles.isEmpty()) {
            this.setProjectProfile(PROJECT_DEFAULT_PROFILE_NAME);
            Profile projectProfile = this.myApplicationProfileManager.createProfile();
            projectProfile.copyFrom(this.myApplicationProfileManager.getRootProfile());
            projectProfile.setProjectLevel(true);
            projectProfile.setName(PROJECT_DEFAULT_PROFILE_NAME);
            this.myProfiles.put(PROJECT_DEFAULT_PROFILE_NAME, projectProfile);
        } else if (!this.myProfiles.containsKey(this.myProjectProfile)) {
            this.setProjectProfile(this.myProfiles.keySet().iterator().next());
        }
        Profile profile = this.myProfiles.get(this.myProjectProfile);
        if (profile.isProjectLevel()) {
            profile.setProfileManager(this);
        }
        return profile;
    }

    public void addProfilesListener(final @NotNull ProfileChangeAdapter profilesListener, @NotNull Disposable parent) {
        this.myProfilesListener.add(profilesListener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DefaultProjectProfileManager.this.myProfilesListener.remove(profilesListener);
            }
        });
    }

    protected void fireProfilesInitialized() {
        for (ProfileChangeAdapter profileChangeAdapter : this.myProfilesListener) {
            profileChangeAdapter.profilesInitialized();
        }
    }

    protected void fireProfilesShutdown() {
        for (ProfileChangeAdapter profileChangeAdapter : this.myProfilesListener) {
            profileChangeAdapter.profilesShutdown();
        }
    }

    public static class ProfileStateSplitter
    extends MainConfigurationStateSplitter {
        @Override
        @NotNull
        protected String getComponentStateFileName() {
            return "profiles_settings";
        }

        @Override
        @NotNull
        protected String getSubStateTagName() {
            return DefaultProjectProfileManager.PROFILE;
        }
    }
}

