/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InitialPatternCondition<T> {
    private final Class<T> myAcceptedClass;

    protected InitialPatternCondition(@NotNull Class<T> aAcceptedClass) {
        this.myAcceptedClass = aAcceptedClass;
    }

    @NotNull
    public Class<T> getAcceptedClass() {
        return this.myAcceptedClass;
    }

    public boolean accepts(@Nullable Object o, ProcessingContext context) {
        return this.myAcceptedClass.isInstance(o);
    }

    @NonNls
    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    public void append(@NonNls @NotNull StringBuilder builder, String indent) {
        builder.append("instanceOf(").append(this.myAcceptedClass.getSimpleName()).append(")");
    }
}

