/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefreshQueue {
    public static RefreshQueue getInstance() {
        return ServiceManager.getService(RefreshQueue.class);
    }

    @NotNull
    public final RefreshSession createSession(boolean async, boolean recursive, @Nullable Runnable finishRunnable) {
        return this.createSession(async, recursive, finishRunnable, this.getDefaultModalityState());
    }

    @NotNull
    public abstract RefreshSession createSession(boolean var1, boolean var2, @Nullable Runnable var3, @NotNull ModalityState var4);

    public final void refresh(boolean async, boolean recursive, @Nullable Runnable finishRunnable, VirtualFile ... files) {
        this.refresh(async, recursive, finishRunnable, this.getDefaultModalityState(), files);
    }

    public final void refresh(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull Collection<? extends VirtualFile> files) {
        this.refresh(async, recursive, finishRunnable, this.getDefaultModalityState(), files);
    }

    public final void refresh(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull ModalityState state, VirtualFile ... files) {
        RefreshSession session = this.createSession(async, recursive, finishRunnable, state);
        session.addAllFiles(files);
        session.launch();
    }

    public final void refresh(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull ModalityState state, @NotNull Collection<? extends VirtualFile> files) {
        RefreshSession session = this.createSession(async, recursive, finishRunnable, state);
        session.addAllFiles(files);
        session.launch();
    }

    public abstract void processSingleEvent(@NotNull VFileEvent var1);

    public abstract void cancelSession(long var1);

    @NotNull
    protected ModalityState getDefaultModalityState() {
        return ModalityState.NON_MODAL;
    }
}

