/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewVirtualFile
extends VirtualFile
implements VirtualFileWithId {
    @Override
    public boolean isValid() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.exists();
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        throw new IOException("Cannot get content of " + this);
    }

    @Override
    @NotNull
    public abstract NewVirtualFileSystem getFileSystem();

    @Override
    public abstract NewVirtualFile getParent();

    @Override
    @Nullable
    public abstract NewVirtualFile getCanonicalFile();

    @Override
    @Nullable
    public abstract NewVirtualFile findChild(@NotNull @NonNls String var1);

    @Nullable
    public abstract NewVirtualFile refreshAndFindChild(@NotNull String var1);

    @Nullable
    public abstract NewVirtualFile findChildIfCached(@NotNull String var1);

    public abstract void setTimeStamp(long var1) throws IOException;

    @Override
    @NotNull
    public abstract CharSequence getNameSequence();

    @Override
    public abstract int getId();

    @Deprecated
    @Nullable
    public NewVirtualFile findChildById(int id) {
        return null;
    }

    @Deprecated
    @Nullable
    public NewVirtualFile findChildByIdIfCached(int id) {
        return null;
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        RefreshQueue.getInstance().refresh(asynchronous, recursive, postRunnable, this);
    }

    @Override
    public abstract void setWritable(boolean var1) throws IOException;

    public abstract void markDirty();

    public abstract void markDirtyRecursively();

    public abstract boolean isDirty();

    public abstract void markClean();

    @Override
    public void move(final Object requestor, final @NotNull VirtualFile newParent) throws IOException {
        if (!this.exists()) {
            throw new IOException("File to move does not exist: " + this.getPath());
        }
        if (!newParent.exists()) {
            throw new IOException("Destination folder does not exist: " + newParent.getPath());
        }
        if (!newParent.isDirectory()) {
            throw new IOException("Destination is not a folder: " + newParent.getPath());
        }
        VirtualFile child = newParent.findChild(this.getName());
        if (child != null) {
            throw new IOException("Destination already exists: " + newParent.getPath() + "/" + this.getName());
        }
        EncodingRegistry.doActionAndRestoreEncoding(this, new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                NewVirtualFile.this.getFileSystem().moveFile(requestor, NewVirtualFile.this, newParent);
                return NewVirtualFile.this;
            }
        });
    }

    @NotNull
    public abstract Collection<VirtualFile> getCachedChildren();

    @NotNull
    public abstract Iterable<VirtualFile> iterInDbChildren();
}

