/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.SavingRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileEvent
extends EventObject {
    private final VirtualFile myFile;
    private final VirtualFile myParent;
    private final Object myRequestor;
    private final String myFileName;
    private final long myOldModificationStamp;
    private final long myNewModificationStamp;

    public VirtualFileEvent(@Nullable Object requestor, @NotNull VirtualFile file, @NotNull String fileName, @Nullable VirtualFile parent) {
        this(requestor, file, fileName, parent, 0L, 0L);
    }

    public VirtualFileEvent(@Nullable Object requestor, @NotNull VirtualFile file, @Nullable VirtualFile parent, long oldModificationStamp, long newModificationStamp) {
        this(requestor, file, file.getName(), parent, oldModificationStamp, newModificationStamp);
    }

    private VirtualFileEvent(@Nullable Object requestor, @NotNull VirtualFile file, @NotNull String fileName, @Nullable VirtualFile parent, long oldModificationStamp, long newModificationStamp) {
        super(file);
        this.myFile = file;
        this.myFileName = fileName;
        this.myParent = parent;
        this.myRequestor = requestor == null ? file.getUserData(VirtualFile.REQUESTOR_MARKER) : requestor;
        this.myOldModificationStamp = oldModificationStamp;
        this.myNewModificationStamp = newModificationStamp;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    @Nullable
    public Object getRequestor() {
        return this.myRequestor;
    }

    public long getOldModificationStamp() {
        return this.myOldModificationStamp;
    }

    public long getNewModificationStamp() {
        return this.myNewModificationStamp;
    }

    public boolean isFromRefresh() {
        return this.myRequestor == null;
    }

    public boolean isFromSave() {
        return this.myRequestor instanceof SavingRequestor;
    }
}

