/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardFileSystems {
    public static final String FILE_PROTOCOL = "file";
    public static final String FILE_PROTOCOL_PREFIX = "file://";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_PROTOCOL_PREFIX = "jar://";
    public static final String JRT_PROTOCOL = "jrt";
    private static final NotNullLazyValue<VirtualFileSystem> ourLocal = new NotNullLazyValue<VirtualFileSystem>(){

        @NotNull
        protected VirtualFileSystem compute() {
            return VirtualFileManager.getInstance().getFileSystem(StandardFileSystems.FILE_PROTOCOL);
        }
    };
    private static final NotNullLazyValue<VirtualFileSystem> ourJar = new NotNullLazyValue<VirtualFileSystem>(){

        @NotNull
        protected VirtualFileSystem compute() {
            return VirtualFileManager.getInstance().getFileSystem(StandardFileSystems.JAR_PROTOCOL);
        }
    };

    public static VirtualFileSystem local() {
        return (VirtualFileSystem)ourLocal.getValue();
    }

    public static VirtualFileSystem jar() {
        return (VirtualFileSystem)ourJar.getValue();
    }

    @Nullable
    public static VirtualFile getJarRootForLocalFile(@NotNull VirtualFile virtualFile) {
        return StandardFileSystems.jar().findFileByPath(virtualFile.getPath() + "!/");
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path2 = entryVFile.getPath();
        int separatorIndex = path2.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path2.substring(0, separatorIndex);
        return StandardFileSystems.local().findFileByPath(localPath);
    }
}

