/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsException
extends Exception {
    public static final VcsException[] EMPTY_ARRAY = new VcsException[0];
    private VirtualFile myVirtualFile;
    private Collection<String> myMessages;
    private boolean isWarning = false;

    public VcsException(String message) {
        super(message);
        this.initMessage(message);
    }

    private void initMessage(String message) {
        String shownMessage = message == null ? VcsBundle.message("exception.text.unknown.error", new Object[0]) : message;
        this.myMessages = Collections.singleton(shownMessage);
    }

    public VcsException(Throwable throwable, boolean isWarning) {
        this(VcsException.getMessage(throwable), throwable);
        this.isWarning = isWarning;
    }

    public VcsException(Throwable throwable) {
        this(throwable, false);
    }

    public VcsException(String message, Throwable cause) {
        super(message, cause);
        this.initMessage(message);
    }

    public VcsException(String message, boolean isWarning) {
        this(message);
        this.isWarning = isWarning;
    }

    public VcsException(Collection<String> messages) {
        this.myMessages = messages;
    }

    public void setVirtualFile(VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public String[] getMessages() {
        return ArrayUtil.toStringArray(this.myMessages);
    }

    public VcsException setIsWarning(boolean warning) {
        this.isWarning = warning;
        return this;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    @Override
    @NotNull
    public String getMessage() {
        return StringUtil.join(this.myMessages, (String)", ");
    }

    @Nullable
    public static String getMessage(@Nullable Throwable throwable) {
        return throwable != null ? (String)ObjectUtils.chooseNotNull((Object)throwable.getMessage(), (Object)throwable.getLocalizedMessage()) : null;
    }
}

