/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class OutgoingChangesUtil {
    public static <T extends CommittedChangeList> Collection<Pair<VcsRevisionNumber, List<T>>> getVcsRootsForChanges(AbstractVcs vcs, Collection<Change> changes) throws VcsException {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(vcs.getProject());
        VcsOutgoingChangesProvider provider = vcs.getOutgoingChangesProvider();
        if (provider == null) {
            return Collections.emptyList();
        }
        VirtualFile[] files = ChangesUtil.getFilesFromChanges(changes);
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        for (VirtualFile file : files) {
            VirtualFile root = vcsManager.getVcsRootFor(file);
            if (root == null) continue;
            roots.add(root);
        }
        ArrayList<Pair<VcsRevisionNumber, List<T>>> result = new ArrayList<Pair<VcsRevisionNumber, List<T>>>(roots.size());
        for (VirtualFile root : roots) {
            Pair pair = provider.getOutgoingChanges(root, true);
            result.add(pair);
        }
        return result;
    }
}

