/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IssueNavigationLink {
    private String myIssueRegexp = "";
    private String myLinkRegexp = "";
    private Pattern myIssuePattern;

    public IssueNavigationLink() {
    }

    public IssueNavigationLink(@NonNls String issueRegexp, @NonNls String linkRegexp) {
        this.myIssueRegexp = issueRegexp;
        this.myLinkRegexp = linkRegexp;
    }

    @NotNull
    public String getIssueRegexp() {
        return this.myIssueRegexp;
    }

    public void setIssueRegexp(String issueRegexp) {
        this.myIssueRegexp = issueRegexp;
        this.myIssuePattern = null;
    }

    public Pattern getIssuePattern() {
        if (this.myIssuePattern == null) {
            this.myIssuePattern = Pattern.compile(this.myIssueRegexp);
        }
        return this.myIssuePattern;
    }

    @NotNull
    public String getLinkRegexp() {
        return this.myLinkRegexp;
    }

    public void setLinkRegexp(String linkRegexp) {
        this.myLinkRegexp = linkRegexp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueNavigationLink that = (IssueNavigationLink)o;
        if (!this.myIssueRegexp.equals(that.myIssueRegexp)) {
            return false;
        }
        return this.myLinkRegexp.equals(that.myLinkRegexp);
    }

    public int hashCode() {
        int result = this.myIssueRegexp.hashCode();
        result = 31 * result + this.myLinkRegexp.hashCode();
        return result;
    }
}

