/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcsHelper {
    protected final Project myProject;

    protected AbstractVcsHelper(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public static AbstractVcsHelper getInstance(Project project) {
        return PeriodicalTasksCloser.getInstance().safeGetService(project, AbstractVcsHelper.class);
    }

    public abstract void showErrors(List<VcsException> var1, @NotNull String var2);

    public abstract void showErrors(Map<HotfixData, List<VcsException>> var1, @NotNull String var2);

    public abstract List<VcsException> runTransactionRunnable(AbstractVcs var1, TransactionRunnable var2, Object var3);

    public void showError(VcsException e, String tabDisplayName) {
        this.showErrors(Arrays.asList(e), tabDisplayName);
    }

    public abstract void showAnnotation(FileAnnotation var1, VirtualFile var2, AbstractVcs var3);

    public abstract void showAnnotation(FileAnnotation var1, VirtualFile var2, AbstractVcs var3, int var4);

    public abstract void showDifferences(VcsFileRevision var1, VcsFileRevision var2, File var3);

    public abstract void showChangesListBrowser(CommittedChangeList var1, @Nls String var2);

    public void showChangesListBrowser(CommittedChangeList changelist, @Nullable VirtualFile toSelect, @Nls String title) {
        this.showChangesListBrowser(changelist, title);
    }

    public abstract void showChangesBrowser(List<CommittedChangeList> var1);

    public abstract void showChangesBrowser(List<CommittedChangeList> var1, @Nls String var2);

    public abstract void showChangesBrowser(CommittedChangesProvider var1, RepositoryLocation var2, @Nls String var3, @Nullable Component var4);

    public abstract void showWhatDiffersBrowser(@Nullable Component var1, Collection<Change> var2, @Nls String var3);

    @Nullable
    public abstract <T extends CommittedChangeList, U extends ChangeBrowserSettings> T chooseCommittedChangeList(@NotNull CommittedChangesProvider<T, U> var1, RepositoryLocation var2);

    public abstract void openCommittedChangesTab(AbstractVcs var1, VirtualFile var2, ChangeBrowserSettings var3, int var4, String var5);

    public abstract void openCommittedChangesTab(CommittedChangesProvider var1, RepositoryLocation var2, ChangeBrowserSettings var3, int var4, String var5);

    @NotNull
    public abstract List<VirtualFile> showMergeDialog(List<VirtualFile> var1, MergeProvider var2, @NotNull MergeDialogCustomizer var3);

    @NotNull
    public final List<VirtualFile> showMergeDialog(List<VirtualFile> files, MergeProvider provider) {
        return this.showMergeDialog(files, provider, new MergeDialogCustomizer());
    }

    @NotNull
    public final List<VirtualFile> showMergeDialog(List<VirtualFile> files) {
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        MergeProvider provider = null;
        for (VirtualFile virtualFile : files) {
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance(this.myProject).getVcsFor(virtualFile);
            if (vcs == null || (provider = vcs.getMergeProvider()) == null) continue;
            break;
        }
        if (provider == null) {
            return Collections.emptyList();
        }
        return this.showMergeDialog(files, provider);
    }

    public abstract void showFileHistory(@NotNull VcsHistoryProvider var1, @NotNull FilePath var2, @NotNull AbstractVcs var3, @Nullable String var4);

    public abstract void showFileHistory(@NotNull VcsHistoryProvider var1, @Nullable AnnotationProvider var2, @NotNull FilePath var3, @Nullable String var4, @NotNull AbstractVcs var5);

    public abstract void showRollbackChangesDialog(List<Change> var1);

    @Nullable
    public abstract Collection<VirtualFile> selectFilesToProcess(List<VirtualFile> var1, String var2, @Nullable String var3, String var4, String var5, VcsShowConfirmationOption var6);

    @Nullable
    public abstract Collection<FilePath> selectFilePathsToProcess(List<FilePath> var1, String var2, @Nullable String var3, String var4, String var5, VcsShowConfirmationOption var6);

    @Nullable
    public Collection<FilePath> selectFilePathsToProcess(List<FilePath> files, String title, @Nullable String prompt, String singleFileTitle, String singleFilePromptTemplate, VcsShowConfirmationOption confirmationOption, @Nullable String okActionName, @Nullable String cancelActionName) {
        return this.selectFilePathsToProcess(files, title, prompt, singleFileTitle, singleFilePromptTemplate, confirmationOption);
    }

    public abstract boolean commitChanges(@NotNull Collection<Change> var1, @NotNull LocalChangeList var2, @NotNull String var3, @Nullable CommitResultHandler var4);

    public abstract void loadAndShowCommittedChangesDetails(@NotNull Project var1, @NotNull VcsRevisionNumber var2, @NotNull VirtualFile var3, @NotNull VcsKey var4, @Nullable RepositoryLocation var5, boolean var6);
}

