/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.text.StringTokenizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryUtil {
    private LibraryUtil() {
    }

    public static boolean isClassAvailableInLibrary(Library library, String fqn) {
        return LibraryUtil.isClassAvailableInLibrary(library.getFiles(OrderRootType.CLASSES), fqn);
    }

    public static boolean isClassAvailableInLibrary(VirtualFile[] files, String fqn) {
        return LibraryUtil.isClassAvailableInLibrary(Arrays.asList(files), fqn);
    }

    public static boolean isClassAvailableInLibrary(List<VirtualFile> files, String fqn) {
        for (VirtualFile file : files) {
            if (!LibraryUtil.findInFile(file, new StringTokenizer(fqn, "."))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Library findLibraryByClass(String fqn, @Nullable Project project) {
        LibraryTable projectTable;
        Library library;
        if (project != null && (library = LibraryUtil.findInTable(projectTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project), fqn)) != null) {
            return library;
        }
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable();
        return LibraryUtil.findInTable(table, fqn);
    }

    private static boolean findInFile(VirtualFile file, StringTokenizer tokenizer) {
        VirtualFile child;
        if (!tokenizer.hasMoreTokens()) {
            return true;
        }
        StringBuilder name = new StringBuilder(tokenizer.nextToken());
        if (!tokenizer.hasMoreTokens()) {
            name.append(".class");
        }
        return (child = file.findChild(name.toString())) != null && LibraryUtil.findInFile(child, tokenizer);
    }

    @Nullable
    private static Library findInTable(LibraryTable table, String fqn) {
        for (Library library : table.getLibraries()) {
            if (!LibraryUtil.isClassAvailableInLibrary(library, fqn)) continue;
            return library;
        }
        return null;
    }

    public static Library createLibrary(LibraryTable libraryTable, @NonNls String baseName) {
        String name = baseName;
        int count = 2;
        while (libraryTable.getLibraryByName(name) != null) {
            name = baseName + " (" + count++ + ")";
        }
        return libraryTable.createLibrary(name);
    }

    public static VirtualFile[] getLibraryRoots(Project project) {
        return LibraryUtil.getLibraryRoots(project, true, true);
    }

    public static VirtualFile[] getLibraryRoots(Project project, boolean includeSourceFiles, boolean includeJdk) {
        return LibraryUtil.getLibraryRoots(ModuleManager.getInstance(project).getModules(), includeSourceFiles, includeJdk);
    }

    public static VirtualFile[] getLibraryRoots(Module[] modules, boolean includeSourceFiles, boolean includeJdk) {
        HashSet roots = new HashSet();
        for (Module module : modules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry entry : orderEntries = moduleRootManager.getOrderEntries()) {
                Object[] files;
                if (entry instanceof LibraryOrderEntry) {
                    Library library = ((LibraryOrderEntry)entry).getLibrary();
                    if (library == null) continue;
                    Object[] objectArray = files = includeSourceFiles ? library.getFiles(OrderRootType.SOURCES) : null;
                    if (files == null || files.length == 0) {
                        files = library.getFiles(OrderRootType.CLASSES);
                    }
                    ContainerUtil.addAll((Collection)roots, (Object[])files);
                    continue;
                }
                if (!includeJdk || !(entry instanceof JdkOrderEntry)) continue;
                JdkOrderEntry jdkEntry = (JdkOrderEntry)entry;
                Object[] objectArray = files = includeSourceFiles ? jdkEntry.getRootFiles(OrderRootType.SOURCES) : null;
                if (files == null || files.length == 0) {
                    files = jdkEntry.getRootFiles(OrderRootType.CLASSES);
                }
                ContainerUtil.addAll((Collection)roots, (Object[])files);
            }
        }
        return VfsUtilCore.toVirtualFileArray((Collection<? extends VirtualFile>)roots);
    }

    @Nullable
    public static Library findLibrary(@NotNull Module module, final @NotNull String name) {
        final Ref result = Ref.create(null);
        OrderEnumerator.orderEntries(module).forEachLibrary(new Processor<Library>(){

            public boolean process(Library library) {
                if (name.equals(library.getName())) {
                    result.set((Object)library);
                    return false;
                }
                return true;
            }
        });
        return (Library)result.get();
    }

    @Nullable
    public static OrderEntry findLibraryEntry(VirtualFile file, Project project) {
        List<OrderEntry> entries = ProjectRootManager.getInstance(project).getFileIndex().getOrderEntriesForFile(file);
        for (OrderEntry entry : entries) {
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry)) continue;
            return entry;
        }
        return null;
    }

    @NotNull
    public static String getPresentableName(@NotNull Library library) {
        String name = library.getName();
        if (name != null) {
            return name;
        }
        String[] urls = library.getUrls(OrderRootType.CLASSES);
        if (urls.length > 0) {
            return PathUtil.getFileName(VfsUtilCore.urlToPath(urls[0]));
        }
        return "Empty Library";
    }
}

