/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathsList;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OrderEnumerator {
    public abstract OrderEnumerator productionOnly();

    public abstract OrderEnumerator compileOnly();

    public abstract OrderEnumerator runtimeOnly();

    public abstract OrderEnumerator withoutSdk();

    public abstract OrderEnumerator withoutLibraries();

    public abstract OrderEnumerator withoutDepModules();

    public abstract OrderEnumerator withoutModuleSourceEntries();

    public OrderEnumerator librariesOnly() {
        return this.withoutSdk().withoutDepModules().withoutModuleSourceEntries();
    }

    public OrderEnumerator sdkOnly() {
        return this.withoutDepModules().withoutLibraries().withoutModuleSourceEntries();
    }

    public VirtualFile[] getAllLibrariesAndSdkClassesRoots() {
        return this.withoutModuleSourceEntries().withoutDepModules().recursively().exportedOnly().classes().usingCache().getRoots();
    }

    public VirtualFile[] getAllSourceRoots() {
        return this.recursively().exportedOnly().sources().usingCache().getRoots();
    }

    public abstract OrderEnumerator recursively();

    public abstract OrderEnumerator exportedOnly();

    public abstract OrderEnumerator satisfying(Condition<OrderEntry> var1);

    public abstract OrderEnumerator using(@NotNull RootModelProvider var1);

    public abstract boolean shouldRecurse(@NotNull ModuleOrderEntry var1, @NotNull List<OrderEnumerationHandler> var2);

    public abstract OrderRootsEnumerator classes();

    public abstract OrderRootsEnumerator sources();

    public abstract OrderRootsEnumerator roots(@NotNull OrderRootType var1);

    public abstract OrderRootsEnumerator roots(@NotNull NotNullFunction<OrderEntry, OrderRootType> var1);

    public VirtualFile[] getClassesRoots() {
        return this.classes().getRoots();
    }

    public VirtualFile[] getSourceRoots() {
        return this.sources().getRoots();
    }

    public PathsList getPathsList() {
        return this.classes().getPathsList();
    }

    public PathsList getSourcePathsList() {
        return this.sources().getPathsList();
    }

    public abstract void forEach(@NotNull Processor<OrderEntry> var1);

    public abstract void forEachLibrary(@NotNull Processor<Library> var1);

    public abstract void forEachModule(@NotNull Processor<Module> var1);

    public abstract <R> R process(@NotNull RootPolicy<R> var1, R var2);

    @NotNull
    public static OrderEnumerator orderEntries(@NotNull Module module) {
        return ModuleRootManager.getInstance(module).orderEntries();
    }

    @NotNull
    public static OrderEnumerator orderEntries(@NotNull Project project) {
        return ProjectRootManager.getInstance(project).orderEntries();
    }
}

