/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.pom.java.LanguageLevel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageLevelModuleExtensionImpl
extends ModuleExtension<LanguageLevelModuleExtensionImpl>
implements LanguageLevelModuleExtension {
    @NonNls
    private static final String LANGUAGE_LEVEL_ELEMENT_NAME = "LANGUAGE_LEVEL";
    private Module myModule;
    private final boolean myWritable;
    private static final Logger LOG = Logger.getInstance((String)("#" + LanguageLevelModuleExtensionImpl.class.getName()));
    private LanguageLevel myLanguageLevel;
    private final LanguageLevelModuleExtensionImpl mySource;

    public static LanguageLevelModuleExtensionImpl getInstance(Module module) {
        return ModuleRootManager.getInstance(module).getModuleExtension(LanguageLevelModuleExtensionImpl.class);
    }

    public LanguageLevelModuleExtensionImpl(Module module) {
        this.myModule = module;
        this.mySource = null;
        this.myWritable = false;
    }

    public LanguageLevelModuleExtensionImpl(LanguageLevelModuleExtensionImpl source, boolean writable) {
        this.myWritable = writable;
        this.myModule = source.myModule;
        this.myLanguageLevel = source.myLanguageLevel;
        this.mySource = source;
    }

    @Override
    public void setLanguageLevel(LanguageLevel languageLevel) {
        LOG.assertTrue(this.myWritable, (Object)"Writable model can be retrieved from writable ModifiableRootModel");
        this.myLanguageLevel = languageLevel;
    }

    public void readExternal(@NotNull Element element) {
        String languageLevel = element.getAttributeValue(LANGUAGE_LEVEL_ELEMENT_NAME);
        if (languageLevel != null) {
            try {
                this.myLanguageLevel = LanguageLevel.valueOf(languageLevel);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            this.myLanguageLevel = null;
        }
    }

    public void writeExternal(Element element) {
        if (this.myLanguageLevel != null) {
            element.setAttribute(LANGUAGE_LEVEL_ELEMENT_NAME, this.myLanguageLevel.toString());
        }
    }

    @Override
    public ModuleExtension getModifiableModel(boolean writable) {
        return new LanguageLevelModuleExtensionImpl(this, writable);
    }

    @Override
    public void commit() {
        if (this.mySource != null && this.mySource.myLanguageLevel != this.myLanguageLevel) {
            this.mySource.myLanguageLevel = this.myLanguageLevel;
            LanguageLevelProjectExtension.getInstance(this.myModule.getProject()).languageLevelsChanged();
        }
    }

    @Override
    public boolean isChanged() {
        return this.mySource != null && this.mySource.myLanguageLevel != this.myLanguageLevel;
    }

    public void dispose() {
        this.myModule = null;
        this.myLanguageLevel = null;
    }

    @Override
    @Nullable
    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }
}

