/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaSdk
extends SdkType
implements JavaSdkType {
    public JavaSdk(@NotNull @NonNls String name) {
        super(name);
    }

    public static JavaSdk getInstance() {
        return ApplicationManager.getApplication().getComponent(JavaSdk.class);
    }

    @NotNull
    public final Sdk createJdk(@NotNull String jdkName, @NotNull String jreHome) {
        return this.createJdk(jdkName, jreHome, true);
    }

    public abstract int compareTo(@NotNull String var1, @NotNull String var2);

    @NotNull
    public abstract Sdk createJdk(@NonNls String var1, @NotNull String var2, boolean var3);

    @Nullable
    public abstract JavaSdkVersion getVersion(@NotNull Sdk var1);

    @Nullable
    public abstract JavaSdkVersion getVersion(@NotNull String var1);

    public abstract boolean isOfVersionOrHigher(@NotNull Sdk var1, @NotNull JavaSdkVersion var2);

    public static boolean checkForJdk(@NotNull File file) {
        return JdkUtil.checkForJdk(file);
    }

    public static boolean checkForJre(@NotNull String file) {
        return JdkUtil.checkForJre(file);
    }

    @Nullable
    public static String getJdkVersion(@NotNull String sdkHome) {
        return SdkVersionUtil.detectJdkVersion(sdkHome);
    }
}

