/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayDeque;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTaskQueue<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.AbstractTaskQueue");
    private final Object myLock = new Object();
    private final Queue<T> myQueue = new ArrayDeque<T>();
    private boolean myActive = false;
    protected final Runnable myQueueWorker = new MyWorker();

    protected abstract void runMe();

    protected abstract void runStuff(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull T stuff) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.runStuff(stuff);
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            try {
                this.myQueue.add(stuff);
                if (!this.myActive) {
                    this.runMe();
                }
            }
            catch (Throwable t) {
                LOG.info(t);
                throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            }
            finally {
                this.myActive = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myQueue.isEmpty()) {
                this.myActive = false;
                return true;
            }
        }
        return false;
    }

    private class MyWorker
    implements Runnable {
        private MyWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Object stuff;
                    Object object = AbstractTaskQueue.this.myLock;
                    synchronized (object) {
                        stuff = AbstractTaskQueue.this.myQueue.poll();
                    }
                    if (stuff == null) continue;
                    AbstractTaskQueue.this.runStuff(stuff);
                    continue;
                }
                catch (Throwable t) {
                    LOG.info(t);
                }
                finally {
                    if (!AbstractTaskQueue.this.isEmpty()) continue;
                    return;
                    continue;
                }
                break;
            }
        }
    }
}

