/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileElement {
    private final VirtualFile myFile;
    private final String myName;
    private String myPath;
    private FileElement myParent;

    public FileElement(@Nullable VirtualFile file, String name) {
        this.myFile = file;
        this.myName = name;
    }

    public void setParent(FileElement parent) {
        this.myParent = parent;
    }

    public FileElement getParent() {
        return this.myParent;
    }

    public final VirtualFile getFile() {
        return this.myFile;
    }

    public final String getName() {
        return this.myName;
    }

    @NotNull
    public final String getPath() {
        if (this.myPath == null) {
            StringBuilder sb = new StringBuilder();
            FileElement element = this;
            while (element != null) {
                if (element.myParent != null || !element.myName.equals(File.separator)) {
                    sb.insert(0, element.myName);
                }
                if ((element = element.myParent) == null) continue;
                sb.insert(0, File.separator);
            }
            this.myPath = sb.toString();
        }
        return this.myPath;
    }

    public int hashCode() {
        return this.myFile == null ? 0 : this.myFile.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FileElement && Comparing.equal((Object)((FileElement)obj).myFile, (Object)this.myFile);
    }

    public final String toString() {
        return this.myName != null ? this.myName : "";
    }

    public final boolean isHidden() {
        return FileElement.isFileHidden(this.myFile);
    }

    public final boolean isArchive() {
        return FileElement.isArchive(this.getFile());
    }

    public static boolean isFileHidden(@Nullable VirtualFile file) {
        return file != null && file.isValid() && file.isInLocalFileSystem() && (file.is(VFileProperty.HIDDEN) || SystemInfo.isUnix && file.getName().startsWith("."));
    }

    public static boolean isArchive(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (FileElement.isArchiveFileSystem(file) && file.getParent() == null) {
            return true;
        }
        return !file.isDirectory() && file.getFileType() == FileTypes.ARCHIVE && !FileElement.isArchiveFileSystem(file.getParent());
    }

    private static boolean isArchiveFileSystem(VirtualFile file) {
        return file.getFileSystem() instanceof JarFileSystem;
    }
}

