/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModelsProviderImpl
implements IdeModelsProvider {
    @NotNull
    protected final Project myProject;

    public IdeModelsProviderImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public Module[] getModules() {
        return ModuleManager.getInstance(this.myProject).getModules();
    }

    @Override
    @NotNull
    public Module[] getModules(final @NotNull ProjectData projectData) {
        List modules = ContainerUtil.filter((Object[])this.getModules(), (Condition)new Condition<Module>(){

            public boolean value(Module module) {
                return ExternalSystemApiUtil.isExternalSystemAwareModule(projectData.getOwner(), module) && StringUtil.equals((CharSequence)projectData.getLinkedExternalProjectPath(), (CharSequence)ExternalSystemApiUtil.getExternalRootProjectPath(module));
            }
        });
        return (Module[])ContainerUtil.toArray((List)modules, (Object[])new Module[modules.size()]);
    }

    @Override
    @NotNull
    public OrderEntry[] getOrderEntries(@NotNull Module module) {
        return ModuleRootManager.getInstance(module).getOrderEntries();
    }

    @Override
    @Nullable
    public Module findIdeModule(@NotNull ModuleData module) {
        Module ideModule = this.findIdeModule(module.getInternalName());
        return ExternalSystemApiUtil.isExternalSystemAwareModule(module.getOwner(), ideModule) ? ideModule : null;
    }

    @Override
    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        for (Module module : this.getModules()) {
            if (!ideModuleName.equals(module.getName())) continue;
            return module;
        }
        return null;
    }

    @Override
    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject);
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated(ideLibrary, libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Override
    @Nullable
    public ModuleOrderEntry findIdeModuleDependency(@NotNull ModuleDependencyData dependency, @NotNull Module module) {
        for (OrderEntry entry : this.getOrderEntries(module)) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry candidate = (ModuleOrderEntry)entry;
            if (!dependency.getInternalName().equals(candidate.getModuleName()) || !dependency.getScope().equals((Object)candidate.getScope())) continue;
            return candidate;
        }
        return null;
    }

    @Override
    @Nullable
    public OrderEntry findIdeModuleOrderEntry(@NotNull DependencyData data) {
        Module ownerIdeModule = this.findIdeModule(data.getOwnerModule());
        if (ownerIdeModule == null) {
            return null;
        }
        LibraryDependencyData libraryDependencyData = null;
        ModuleDependencyData moduleDependencyData = null;
        if (data instanceof LibraryDependencyData) {
            libraryDependencyData = (LibraryDependencyData)data;
        } else if (data instanceof ModuleDependencyData) {
            moduleDependencyData = (ModuleDependencyData)data;
        } else {
            return null;
        }
        for (OrderEntry entry : this.getOrderEntries(ownerIdeModule)) {
            String entryName;
            if (entry instanceof LibraryOrderEntry && libraryDependencyData != null) {
                if (((LibraryOrderEntry)entry).isModuleLevel() && libraryDependencyData.getLevel() != LibraryLevel.MODULE) continue;
                if (StringUtil.isEmpty((String)((LibraryOrderEntry)entry).getLibraryName())) {
                    Set paths = ContainerUtil.map2Set(((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY), (Function)new Function<String, String>(){

                        public String fun(String path2) {
                            return PathUtil.getLocalPath(path2);
                        }
                    });
                    Set entryPaths = ContainerUtil.map2Set((Object[])entry.getUrls(OrderRootType.CLASSES), (Function)new Function<String, String>(){

                        public String fun(String s) {
                            return PathUtil.getLocalPath(VfsUtilCore.urlToPath(s));
                        }
                    });
                    if (!entryPaths.equals(paths) || ((LibraryOrderEntry)entry).getScope() != data.getScope()) continue;
                    return entry;
                }
            }
            String string = entryName = libraryDependencyData != null ? libraryDependencyData.getInternalName() : moduleDependencyData.getInternalName();
            if (!entryName.equals(entry.getPresentableName()) || entry instanceof ExportableOrderEntry && ((ExportableOrderEntry)entry).getScope() != data.getScope()) continue;
            return entry;
        }
        return null;
    }

    @Override
    @NotNull
    public VirtualFile[] getContentRoots(Module module) {
        return ModuleRootManager.getInstance(module).getContentRoots();
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceRoots(Module module) {
        return ModuleRootManager.getInstance(module).getSourceRoots();
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceRoots(Module module, boolean includingTests) {
        return ModuleRootManager.getInstance(module).getSourceRoots(includingTests);
    }

    @Override
    @NotNull
    public Library[] getAllLibraries() {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraries();
    }

    @Override
    @Nullable
    public Library getLibraryByName(String name) {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraryByName(name);
    }

    @Override
    @NotNull
    public String[] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        return library.getUrls(type);
    }

    @Override
    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module) {
        return ModuleUtilCore.getAllDependentModules(module);
    }
}

