/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.roots.DependencyScope;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDependencyData<T extends AbstractExternalEntityData>
extends AbstractExternalEntityData
implements DependencyData,
Named,
OrderAware {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final ModuleData myOwnerModule;
    @NotNull
    private final T myTarget;
    private DependencyScope myScope = DependencyScope.COMPILE;
    private boolean myExported;
    private int myOrder;

    protected AbstractDependencyData(@NotNull ModuleData ownerModule, @NotNull T dependency) {
        super(ownerModule.getOwner());
        this.myOwnerModule = ownerModule;
        this.myTarget = dependency;
    }

    @Override
    @NotNull
    public ModuleData getOwnerModule() {
        return this.myOwnerModule;
    }

    @Override
    @NotNull
    public T getTarget() {
        return this.myTarget;
    }

    @Override
    @NotNull
    public DependencyScope getScope() {
        return this.myScope;
    }

    public void setScope(DependencyScope scope) {
        this.myScope = scope;
    }

    @Override
    public boolean isExported() {
        return this.myExported;
    }

    public void setExported(boolean exported) {
        this.myExported = exported;
    }

    @Override
    @Deprecated
    @NotNull
    public String getName() {
        return ((Named)this.myTarget).getName();
    }

    @Override
    @Deprecated
    public void setName(@NotNull String name) {
        ((Named)this.myTarget).setName(name);
    }

    @Override
    @NotNull
    public String getExternalName() {
        return ((Named)this.myTarget).getExternalName();
    }

    @Override
    public void setExternalName(@NotNull String name) {
        ((Named)this.myTarget).setExternalName(name);
    }

    @Override
    @NotNull
    public String getInternalName() {
        return ((Named)this.myTarget).getInternalName();
    }

    @Override
    public void setInternalName(@NotNull String name) {
        ((Named)this.myTarget).setInternalName(name);
    }

    @Override
    public int getOrder() {
        return this.myOrder;
    }

    public void setOrder(int order) {
        this.myOrder = order;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myScope.hashCode();
        result = 31 * result + this.myOwnerModule.hashCode();
        result = 31 * result + ((AbstractExternalEntityData)this.myTarget).hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AbstractDependencyData that = (AbstractDependencyData)o;
        return this.myScope.equals((Object)that.myScope) && this.myOwnerModule.equals(that.myOwnerModule) && ((AbstractExternalEntityData)this.myTarget).equals(that.myTarget);
    }

    public String toString() {
        return "dependency=" + this.getTarget() + "|scope=" + (Object)((Object)this.getScope()) + "|exported=" + this.isExported() + "|owner=" + this.getOwnerModule();
    }
}

