/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.util.text.StringUtil;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class ProjectSystemId
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    public static final ProjectSystemId IDE = new ProjectSystemId("IDE");
    @NotNull
    private final String myId;
    @NotNull
    private final String myReadableName;

    public ProjectSystemId(@NotNull String id) {
        this(id, StringUtil.capitalize((String)id.toLowerCase()));
    }

    public ProjectSystemId(@NotNull String id, @NotNull String readableName) {
        this.myId = id;
        this.myReadableName = readableName;
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectSystemId owner = (ProjectSystemId)o;
        return this.myId.equals(owner.myId);
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    @NotNull
    public String getReadableName() {
        return this.myReadableName;
    }

    public String toString() {
        return this.myId;
    }
}

