/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceManager {
    private static final Logger LOG = Logger.getInstance(ServiceManager.class);

    private ServiceManager() {
    }

    public static <T> T getService(@NotNull Class<T> serviceClass) {
        return ServiceManager.doGetService(ApplicationManager.getApplication(), serviceClass);
    }

    public static <T> T getService(@NotNull Project project, @NotNull Class<T> serviceClass) {
        return ServiceManager.doGetService(project, serviceClass);
    }

    @Nullable
    private static <T> T doGetService(@NotNull ComponentManager componentManager, @NotNull Class<T> serviceClass) {
        Object instance = componentManager.getPicoContainer().getComponentInstance((Object)serviceClass.getName());
        if (instance == null && (instance = componentManager.getComponent(serviceClass)) != null) {
            Application app = ApplicationManager.getApplication();
            String message = serviceClass.getName() + " requested as a service, but it is a component - convert it to a service or change call to " + (componentManager == app ? "ApplicationManager.getApplication().getComponent()" : "project.getComponent()");
            if (app.isUnitTestMode()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
        }
        return (T)instance;
    }

    public static <T> NotNullLazyKey<T, Project> createLazyKey(final @NotNull Class<T> serviceClass) {
        return NotNullLazyKey.create((String)("Service: " + serviceClass.getName()), (NotNullFunction)new NotNullFunction<Project, T>(){

            @NotNull
            public T fun(Project project) {
                return ServiceManager.getService(project, serviceClass);
            }
        });
    }
}

