/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.findUsages;

import com.intellij.lang.Language;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import org.jetbrains.annotations.NotNull;

public class DescriptiveNameUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.findUsages.DescriptiveNameUtil");

    @NotNull
    public static String getMetaDataName(@NotNull PsiMetaData metaData) {
        String name = metaData.getName();
        return StringUtil.isEmpty((String)name) ? "''" : name;
    }

    @NotNull
    public static String getDescriptiveName(@NotNull PsiElement psiElement) {
        PsiMetaOwner psiMetaOwner;
        PsiMetaData metaData;
        LOG.assertTrue(psiElement.isValid());
        if (psiElement instanceof PsiMetaOwner && (metaData = (psiMetaOwner = (PsiMetaOwner)((Object)psiElement)).getMetaData()) != null) {
            return DescriptiveNameUtil.getMetaDataName(metaData);
        }
        if (psiElement instanceof PsiFile) {
            return ((PsiFile)psiElement).getName();
        }
        Language lang = psiElement.getLanguage();
        FindUsagesProvider provider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(lang);
        assert (provider != null) : lang;
        return provider.getDescriptiveName(psiElement);
    }
}

