/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.LanguageExtension;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class LanguageNamesValidation
extends LanguageExtension<NamesValidator> {
    public static final LanguageNamesValidation INSTANCE = new LanguageNamesValidation();

    private LanguageNamesValidation() {
        super("com.intellij.lang.namesValidator", new DefaultNamesValidator());
    }

    protected static class DefaultNamesValidator
    implements NamesValidator {
        protected DefaultNamesValidator() {
        }

        @Override
        public boolean isIdentifier(@NotNull String name, Project project) {
            int len = name.length();
            if (len == 0) {
                return false;
            }
            if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                return false;
            }
            for (int i = 1; i < len; ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isKeyword(@NotNull String name, Project project) {
            return false;
        }
    }
}

