/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.CommonBundle;
import com.intellij.Patches;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.UrlOpener;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserLauncherAppless
extends BrowserLauncher {
    static final Logger LOG = Logger.getInstance(BrowserLauncherAppless.class);

    private static boolean isDesktopActionSupported(Desktop.Action action) {
        return !Patches.SUN_BUG_ID_6457572 && !Patches.SUN_BUG_ID_6486393 && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(action);
    }

    public static boolean canUseSystemDefaultBrowserPolicy() {
        return BrowserLauncherAppless.isDesktopActionSupported(Desktop.Action.BROWSE) || SystemInfo.isMac || SystemInfo.isWindows || SystemInfo.isUnix && SystemInfo.hasXdgOpen();
    }

    private static GeneralSettings getGeneralSettingsInstance() {
        GeneralSettings settings;
        if (ApplicationManager.getApplication() != null && (settings = GeneralSettings.getInstance()) != null) {
            return settings;
        }
        return new GeneralSettings();
    }

    @Nullable
    private static List<String> getDefaultBrowserCommand() {
        if (SystemInfo.isWindows) {
            return Arrays.asList(ExecUtil.getWindowsShellName(), "/c", "start", GeneralCommandLine.inescapableQuote(""));
        }
        if (SystemInfo.isMac) {
            return Collections.singletonList(ExecUtil.getOpenCommandPath());
        }
        if (SystemInfo.isUnix && SystemInfo.hasXdgOpen()) {
            return Collections.singletonList("xdg-open");
        }
        return null;
    }

    @Override
    public void open(@NotNull String url) {
        this.openOrBrowse(url, false, null);
    }

    @Override
    public void browse(@NotNull File file) {
        this.browse(VfsUtil.toUri(file));
    }

    @Override
    public void browse(@NotNull URI uri) {
        this.browse(uri, null);
    }

    public void browse(@NotNull URI uri, @Nullable Project project) {
        LOG.debug("Launch browser: [" + uri + "]");
        GeneralSettings settings = BrowserLauncherAppless.getGeneralSettingsInstance();
        if (settings.isUseDefaultBrowser()) {
            List<String> command;
            boolean tryToUseCli = true;
            if (BrowserLauncherAppless.isDesktopActionSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(uri);
                    LOG.debug("Browser launched using JDK 1.6 API");
                    return;
                }
                catch (Exception e) {
                    LOG.warn("Error while using Desktop API, fallback to CLI", (Throwable)e);
                    boolean bl = tryToUseCli = !e.getMessage().contains("Error code: -10814");
                }
            }
            if (tryToUseCli && (command = BrowserLauncherAppless.getDefaultBrowserCommand()) != null) {
                this.doLaunch(uri.toString(), command, null, project, ArrayUtil.EMPTY_STRING_ARRAY, null);
                return;
            }
        }
        this.browseUsingNotSystemDefaultBrowserPolicy(uri, settings, project);
    }

    protected void browseUsingNotSystemDefaultBrowserPolicy(@NotNull URI uri, @NotNull GeneralSettings settings, @Nullable Project project) {
        this.browseUsingPath(uri.toString(), settings.getBrowserPath(), null, project, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    private void openOrBrowse(@NotNull String url, boolean browse, @Nullable Project project) {
        if (!BrowserUtil.isAbsoluteURL(url = url.trim())) {
            File file = new File(url);
            if (!browse && BrowserLauncherAppless.isDesktopActionSupported(Desktop.Action.OPEN)) {
                if (!file.exists()) {
                    this.showError(IdeBundle.message("error.file.does.not.exist", file.getPath()), null, null, null, null);
                    return;
                }
                try {
                    Desktop.getDesktop().open(file);
                    return;
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
            this.browse(file);
            return;
        }
        URI uri = VfsUtil.toUri(url);
        if (uri == null) {
            this.showError(IdeBundle.message("error.malformed.url", url), null, project, null, null);
        } else {
            this.browse(uri, project);
        }
    }

    @Override
    public void browse(@NotNull String url, @Nullable WebBrowser browser) {
        this.browse(url, browser, null);
    }

    @Override
    public void browse(@NotNull String url, @Nullable WebBrowser browser, @Nullable Project project) {
        if (browser == null) {
            this.openOrBrowse(url, true, project);
        } else {
            for (UrlOpener urlOpener : (UrlOpener[])UrlOpener.EP_NAME.getExtensions()) {
                if (!urlOpener.openUrl(browser, url, project)) continue;
                return;
            }
        }
    }

    @Override
    public boolean browseUsingPath(final @Nullable String url, @Nullable String browserPath, final @Nullable WebBrowser browser, final @Nullable Project project, final @NotNull String[] additionalParameters) {
        Runnable launchTask = null;
        if (browserPath == null && browser != null) {
            browserPath = PathUtil.toSystemDependentName(browser.getPath());
            launchTask = new Runnable(){

                @Override
                public void run() {
                    BrowserLauncherAppless.this.browseUsingPath(url, null, browser, project, additionalParameters);
                }
            };
        }
        return this.doLaunch(url, browserPath, browser, project, additionalParameters, launchTask);
    }

    private boolean doLaunch(@Nullable String url, @Nullable String browserPath, @Nullable WebBrowser browser, @Nullable Project project, @NotNull String[] additionalParameters, @Nullable Runnable launchTask) {
        if (!this.checkPath(browserPath, browser, project, launchTask)) {
            return false;
        }
        return this.doLaunch(url, BrowserUtil.getOpenBrowserCommand(browserPath, false), browser, project, additionalParameters, launchTask);
    }

    @Contract(value="null, _, _, _ -> false")
    public boolean checkPath(@Nullable String browserPath, @Nullable WebBrowser browser, @Nullable Project project, @Nullable Runnable launchTask) {
        if (!StringUtil.isEmptyOrSpaces((String)browserPath)) {
            return true;
        }
        String message = browser != null ? browser.getBrowserNotFoundMessage() : IdeBundle.message("error.please.specify.path.to.web.browser", CommonBundle.settingsActionPath());
        this.showError(message, browser, project, IdeBundle.message("title.browser.not.found", new Object[0]), launchTask);
        return false;
    }

    private boolean doLaunch(@Nullable String url, @NotNull List<String> command, @Nullable WebBrowser browser, @Nullable Project project, @NotNull String[] additionalParameters, @Nullable Runnable launchTask) {
        BrowserSpecificSettings browserSpecificSettings;
        GeneralCommandLine commandLine = new GeneralCommandLine(command);
        if (url != null && url.startsWith("jar:")) {
            return false;
        }
        if (url != null) {
            commandLine.addParameter(url);
        }
        BrowserSpecificSettings browserSpecificSettings2 = browserSpecificSettings = browser == null ? null : browser.getSpecificSettings();
        if (browserSpecificSettings != null) {
            commandLine.getEnvironment().putAll(browserSpecificSettings.getEnvironmentVariables());
        }
        BrowserLauncherAppless.addArgs(commandLine, browserSpecificSettings, additionalParameters);
        try {
            Process process = commandLine.createProcess();
            this.checkCreatedProcess(browser, project, commandLine, process, launchTask);
            return true;
        }
        catch (ExecutionException e) {
            this.showError(e.getMessage(), browser, project, null, null);
            return false;
        }
    }

    protected void checkCreatedProcess(@Nullable WebBrowser browser, @Nullable Project project, @NotNull GeneralCommandLine commandLine, @NotNull Process process, @Nullable Runnable launchTask) {
    }

    protected void showError(@Nullable String error, @Nullable WebBrowser browser, @Nullable Project project, String title, @Nullable Runnable launchTask) {
        LOG.warn(error);
    }

    private static void addArgs(@NotNull GeneralCommandLine command, @Nullable BrowserSpecificSettings settings, @NotNull String[] additional) {
        List<Object> specific;
        List<Object> list = specific = settings == null ? Collections.emptyList() : settings.getAdditionalParameters();
        if (specific.size() + additional.length > 0) {
            if (BrowserLauncherAppless.isOpenCommandUsed(command)) {
                if (BrowserUtil.isOpenCommandSupportArgs()) {
                    command.addParameter("--args");
                } else {
                    LOG.warn("'open' command doesn't allow to pass command line arguments so they will be ignored: " + StringUtil.join(specific, (String)", ") + " " + Arrays.toString(additional));
                    return;
                }
            }
            command.addParameters(specific);
            command.addParameters(additional);
        }
    }

    public static boolean isOpenCommandUsed(@NotNull GeneralCommandLine command) {
        return SystemInfo.isMac && ExecUtil.getOpenCommandPath().equals(command.getExePath());
    }
}

