/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListTableWithButtons<T>
extends Observable {
    private final List<T> myElements = ContainerUtil.newArrayList();
    private final JPanel myPanel;
    private final TableView<T> myTableView = new TableView(this.createListModel()){

        @Override
        protected void createDefaultEditors() {
            super.createDefaultEditors();
            Object editor = this.defaultEditorsByColumnClass.get(String.class);
            if (editor instanceof DefaultCellEditor) {
                ((DefaultCellEditor)editor).getComponent().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        final int column = ListTableWithButtons.this.myTableView.getEditingColumn();
                        final int row = ListTableWithButtons.this.myTableView.getEditingRow();
                        if (e.getModifiers() == 0 && (e.getKeyCode() == 10 || e.getKeyCode() == 9)) {
                            e.consume();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    int nextRow;
                                    this.stopEditing();
                                    int nextColumn = column < ListTableWithButtons.this.myTableView.getColumnCount() - 1 ? column + 1 : 0;
                                    int n = nextRow = nextColumn == 0 ? row + 1 : row;
                                    if (nextRow > ListTableWithButtons.this.myTableView.getRowCount() - 1) {
                                        if (ListTableWithButtons.this.myElements.isEmpty() || !ListTableWithButtons.this.isEmpty(ListTableWithButtons.this.myElements.get(ListTableWithButtons.this.myElements.size() - 1))) {
                                            ToolbarDecorator.findAddButton(ListTableWithButtons.this.myPanel).actionPerformed(null);
                                            return;
                                        }
                                        nextRow = 0;
                                    }
                                    ListTableWithButtons.this.myTableView.scrollRectToVisible(ListTableWithButtons.this.myTableView.getCellRect(nextRow, nextColumn, true));
                                    ListTableWithButtons.this.myTableView.editCellAt(nextRow, nextColumn);
                                }
                            });
                        }
                    }
                });
            }
        }
    };
    private final CommonActionsPanel myActionsPanel;
    private boolean myIsEnabled = true;

    protected ListTableWithButtons() {
        this.myTableView.setRowHeight(new JTextField().getPreferredSize().height);
        this.myTableView.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myTableView.setStriped(true);
        this.myTableView.getTableViewModel().setSortable(false);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTableView);
        this.myPanel = decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListTableWithButtons.this.myTableView.stopEditing();
                ListTableWithButtons.this.setModified();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ListTableWithButtons.this.myElements.isEmpty() || !ListTableWithButtons.this.isEmpty(ListTableWithButtons.this.myElements.get(ListTableWithButtons.this.myElements.size() - 1))) {
                            ListTableWithButtons.this.myElements.add(ListTableWithButtons.this.createElement());
                            ListTableWithButtons.this.myTableView.getTableViewModel().setItems(ListTableWithButtons.this.myElements);
                        }
                        ListTableWithButtons.this.myTableView.scrollRectToVisible(ListTableWithButtons.this.myTableView.getCellRect(ListTableWithButtons.this.myElements.size() - 1, 0, true));
                        ListTableWithButtons.this.myTableView.getComponent().editCellAt(ListTableWithButtons.this.myElements.size() - 1, 0);
                    }
                });
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListTableWithButtons.this.removeSelected();
            }
        }).disableUpDownActions().addExtraActions(this.createExtraActions()).createPanel();
        ToolbarDecorator.findRemoveButton(this.myPanel).addCustomUpdater(new AnActionButtonUpdater(){

            @Override
            public boolean isEnabled(AnActionEvent e) {
                List selection = ListTableWithButtons.this.getSelection();
                if (selection.isEmpty() || !ListTableWithButtons.this.myIsEnabled) {
                    return false;
                }
                for (Object t : selection) {
                    if (ListTableWithButtons.this.canDeleteElement(t)) continue;
                    return false;
                }
                return true;
            }
        });
        ToolbarDecorator.findAddButton(this.myPanel).addCustomUpdater(new AnActionButtonUpdater(){

            @Override
            public boolean isEnabled(AnActionEvent e) {
                return ListTableWithButtons.this.myIsEnabled;
            }
        });
        this.myActionsPanel = decorator.getActionsPanel();
        this.myTableView.getComponent().setSelectionMode(2);
    }

    protected void removeSelected() {
        List selected = this.getSelection();
        if (!selected.isEmpty()) {
            this.myTableView.stopEditing();
            this.setModified();
            int selectedIndex = this.myTableView.getSelectionModel().getLeadSelectionIndex();
            this.myTableView.scrollRectToVisible(this.myTableView.getCellRect(selectedIndex, 0, true));
            selected = ContainerUtil.filter(selected, (Condition)new Condition<T>(){

                public boolean value(T t) {
                    return ListTableWithButtons.this.canDeleteElement(t);
                }
            });
            this.myElements.removeAll(selected);
            this.myTableView.getSelectionModel().clearSelection();
            this.myTableView.getTableViewModel().setItems(this.myElements);
            int prev = selectedIndex - 1;
            if (prev >= 0) {
                this.myTableView.getComponent().getSelectionModel().setSelectionInterval(prev, prev);
            } else if (selectedIndex < this.myElements.size()) {
                this.myTableView.getComponent().getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
            }
        }
    }

    @NotNull
    public TableView<T> getTableView() {
        return this.myTableView;
    }

    protected abstract ListTableModel createListModel();

    protected void setModified() {
        this.setChanged();
        this.notifyObservers();
    }

    protected List<T> getElements() {
        return this.myElements;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public CommonActionsPanel getActionsPanel() {
        return this.myActionsPanel;
    }

    public void setEnabled() {
        this.myTableView.getComponent().setEnabled(true);
        this.myIsEnabled = true;
    }

    public void setDisabled() {
        this.myTableView.getComponent().setEnabled(false);
        this.myIsEnabled = false;
    }

    public void stopEditing() {
        this.myTableView.stopEditing();
    }

    public void refreshValues() {
        this.myTableView.getComponent().repaint();
    }

    protected void setSelection(T element) {
        this.myTableView.setSelection(Collections.singleton(element));
        TableUtil.scrollSelectionToVisible(this.myTableView);
    }

    protected void editSelection(int column) {
        List<T> selection = this.getSelection();
        if (selection.size() != 1) {
            return;
        }
        int row = this.myElements.indexOf(selection.get(0));
        if (row != -1) {
            TableUtil.editCellAt(this.myTableView, (int)row, (int)column);
        }
    }

    protected abstract T createElement();

    protected abstract boolean isEmpty(T var1);

    @NotNull
    protected AnActionButton[] createExtraActions() {
        return new AnActionButton[0];
    }

    @NotNull
    protected List<T> getSelection() {
        int[] selection = this.myTableView.getComponent().getSelectedRows();
        if (selection.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(selection.length);
        for (int row : selection) {
            result.add(this.myElements.get(row));
        }
        return result;
    }

    public void setValues(List<T> envVariables) {
        this.myElements.clear();
        for (T envVariable : envVariables) {
            this.myElements.add(this.cloneElement(envVariable));
        }
        this.myTableView.getTableViewModel().setItems(this.myElements);
    }

    protected abstract T cloneElement(T var1);

    protected abstract boolean canDeleteElement(T var1);

    protected static abstract class ElementsColumnInfoBase<T>
    extends ColumnInfo<T, String> {
        private DefaultTableCellRenderer myRenderer;

        protected ElementsColumnInfoBase(String name) {
            super(name);
        }

        public TableCellRenderer getRenderer(T element) {
            if (this.myRenderer == null) {
                this.myRenderer = new DefaultTableCellRenderer();
            }
            if (element != null) {
                this.myRenderer.setText((String)this.valueOf(element));
                this.myRenderer.setToolTipText(this.getDescription(element));
            }
            return this.myRenderer;
        }

        @Nullable
        protected abstract String getDescription(T var1);
    }
}

