/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturingProcessHandler
extends OSProcessHandler {
    private static final Logger LOG = Logger.getInstance(CapturingProcessHandler.class);
    private final ProcessOutput myOutput = new ProcessOutput();

    public CapturingProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        super(commandLine);
        this.addProcessListener((ProcessListener)this.createProcessAdapter(this.myOutput));
    }

    @Deprecated
    public CapturingProcessHandler(@NotNull Process process) {
        this(process, null, "");
    }

    @Deprecated
    public CapturingProcessHandler(@NotNull Process process, @Nullable Charset charset) {
        this(process, charset, "");
    }

    public CapturingProcessHandler(@NotNull Process process, @Nullable Charset charset, String commandLine) {
        super(process, commandLine, charset);
        this.addProcessListener((ProcessListener)this.createProcessAdapter(this.myOutput));
    }

    protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
        return new CapturingProcessAdapter(processOutput);
    }

    public ProcessOutput runProcess() {
        this.startNotify();
        if (this.waitFor()) {
            this.myOutput.setExitCode(this.getProcess().exitValue());
        } else {
            LOG.info("runProcess: exit value unavailable");
        }
        return this.myOutput;
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds) {
        return this.runProcess(timeoutInMilliseconds, true);
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds, boolean destroyOnTimeout) {
        if (timeoutInMilliseconds <= 0) {
            return this.runProcess();
        }
        this.startNotify();
        if (this.waitFor(timeoutInMilliseconds)) {
            this.myOutput.setExitCode(this.getProcess().exitValue());
        } else {
            if (destroyOnTimeout) {
                this.destroyProcess();
            }
            this.myOutput.setTimeout();
        }
        return this.myOutput;
    }

    public Charset getCharset() {
        return this.myCharset != null ? this.myCharset : super.getCharset();
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator) {
        this.startNotify();
        while (!this.waitFor(100L)) {
            if (!indicator.isCanceled()) continue;
            if (!this.isProcessTerminating() && !this.isProcessTerminated()) {
                this.destroyProcess();
            }
            this.myOutput.setCancelled();
            break;
        }
        if (this.waitFor()) {
            this.myOutput.setExitCode(this.getProcess().exitValue());
        } else {
            LOG.info("runProcess: exit value unavailable");
        }
        return this.myOutput;
    }
}

