/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlFilter
implements Filter {
    @Override
    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        if (!URLUtil.canContainUrl((String)line)) {
            return null;
        }
        int textStartOffset = entireLength - line.length();
        Matcher m = URLUtil.URL_PATTERN.matcher(line);
        Filter.ResultItem item = null;
        ArrayList<Filter.ResultItem> items = null;
        while (m.find()) {
            if (item == null) {
                item = new Filter.ResultItem(textStartOffset + m.start(), textStartOffset + m.end(), this.buildHyperlinkInfo(m.group()));
                continue;
            }
            if (items == null) {
                items = new ArrayList<Filter.ResultItem>(2);
                items.add(item);
            }
            items.add(new Filter.ResultItem(textStartOffset + m.start(), textStartOffset + m.end(), this.buildHyperlinkInfo(m.group())));
        }
        return items != null ? new Filter.Result(items) : (item != null ? new Filter.Result(item.getHighlightStartOffset(), item.getHighlightEndOffset(), item.getHyperlinkInfo()) : null);
    }

    @NotNull
    protected HyperlinkInfo buildHyperlinkInfo(@NotNull String url) {
        return new BrowserHyperlinkInfo(url);
    }

    public static class UrlFilterProvider
    implements ConsoleFilterProviderEx {
        @Override
        public Filter[] getDefaultFilters(@NotNull Project project, @NotNull GlobalSearchScope scope) {
            return new Filter[]{new UrlFilter()};
        }

        @Override
        @NotNull
        public Filter[] getDefaultFilters(@NotNull Project project) {
            return this.getDefaultFilters(project, GlobalSearchScope.allScope(project));
        }
    }
}

