/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import com.pty4j.PtyProcess;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PtyCommandLine
extends GeneralCommandLine {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.PtyCommandLine");
    private static final String RUN_PROCESSES_WITH_PTY = "run.processes.with.pty";
    private boolean myUseCygwinLaunch;
    private boolean myConsoleMode = true;

    public static boolean isEnabled() {
        return Registry.is((String)RUN_PROCESSES_WITH_PTY);
    }

    @Override
    @NotNull
    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        try {
            return this.startProcessWithPty(commands, this.myConsoleMode);
        }
        catch (Throwable t) {
            File logFile = PtyCommandLine.getPtyLogFile();
            if (logFile != null && logFile.exists()) {
                String logContent;
                try {
                    logContent = FileUtil.loadFile((File)logFile);
                }
                catch (Exception e) {
                    logContent = "Unable to retrieve log: " + e.getMessage();
                }
                LOG.error("Couldn't run process with PTY", t, new String[]{logContent});
            } else {
                LOG.error("Couldn't run process with PTY", t);
            }
            return super.startProcess(commands);
        }
    }

    public void setUseCygwinLaunch(boolean useCygwinLaunch) {
        this.myUseCygwinLaunch = useCygwinLaunch;
    }

    public void setConsoleMode(boolean consoleMode) {
        this.myConsoleMode = consoleMode;
    }

    private static File getPtyLogFile() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isEAP() ? new File(PathManager.getLogPath(), "pty.log") : null;
    }

    @NotNull
    public Process startProcessWithPty(@NotNull List<String> commands, boolean console) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        this.setupEnvironment(env);
        if (this.isRedirectErrorStream()) {
            LOG.error("Launching process with PTY and redirected error stream is unsupported yet");
        }
        String[] command = ArrayUtil.toStringArray(commands);
        File workDirectory = this.getWorkDirectory();
        String directory = workDirectory != null ? workDirectory.getPath() : null;
        boolean cygwin = this.myUseCygwinLaunch && SystemInfo.isWindows;
        return PtyProcess.exec((String[])command, env, (String)directory, (boolean)console, (boolean)cygwin, (File)PtyCommandLine.getPtyLogFile());
    }
}

