/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogFileOptions
implements JDOMExternalizable {
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String CHECKED = "checked";
    @NonNls
    private static final String ALIAS = "alias";
    @NonNls
    private static final String SKIPPED = "skipped";
    @NonNls
    private static final String SHOW_ALL = "show_all";
    @NonNls
    private static final String CHARSET = "charset";
    private String myName;
    private String myPathPattern;
    private boolean myEnabled;
    private boolean mySkipContent;
    private boolean myShowAll;
    @NotNull
    private Charset myCharset;

    public LogFileOptions() {
    }

    public LogFileOptions(String name, String path2, boolean enabled, boolean skipContent, boolean showAll) {
        this(name, path2, null, enabled, skipContent, showAll);
    }

    public LogFileOptions(String name, String path2, @Nullable Charset charset, boolean enabled, boolean skipContent, boolean showAll) {
        this.myName = name;
        this.myPathPattern = path2;
        this.myEnabled = enabled;
        this.mySkipContent = skipContent;
        this.myShowAll = showAll;
        this.myCharset = charset != null ? charset : Charset.defaultCharset();
    }

    public String getName() {
        return this.myName;
    }

    public String getPathPattern() {
        return this.myPathPattern;
    }

    @NotNull
    public Set<String> getPaths() {
        File logFile = new File(this.myPathPattern);
        if (logFile.exists()) {
            return Collections.singleton(this.myPathPattern);
        }
        int dirIndex = this.myPathPattern.lastIndexOf(File.separator);
        if (dirIndex == -1) {
            return Collections.emptySet();
        }
        SmartList files = new SmartList();
        LogFileOptions.collectMatchedFiles(new File(this.myPathPattern.substring(0, dirIndex)), Pattern.compile(FileUtil.convertAntToRegexp((String)this.myPathPattern.substring(dirIndex + File.separator.length()))), (List<File>)files);
        if (files.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.myShowAll) {
            SmartHashSet result = new SmartHashSet();
            result.ensureCapacity(files.size());
            for (File file : files) {
                result.add((Object)file.getPath());
            }
            return result;
        }
        File lastFile = null;
        for (File file : files) {
            if (lastFile != null) {
                if (file.lastModified() <= lastFile.lastModified()) continue;
                lastFile = file;
                continue;
            }
            lastFile = file;
        }
        assert (lastFile != null);
        return Collections.singleton(lastFile.getPath());
    }

    public static void collectMatchedFiles(@NotNull File root, @NotNull Pattern pattern, @NotNull List<File> files) {
        File[] dirs = root.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            if (!pattern.matcher(dir.getName()).matches() || !dir.isFile()) continue;
            files.add(dir);
        }
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean isSkipContent() {
        return this.mySkipContent;
    }

    public void setEnable(boolean enable) {
        this.myEnabled = enable;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setPathPattern(String pathPattern) {
        this.myPathPattern = pathPattern;
    }

    public void setSkipContent(boolean skipContent) {
        this.mySkipContent = skipContent;
    }

    public void setShowAll(boolean showAll) {
        this.myShowAll = showAll;
    }

    public void setLast(boolean last) {
        this.myShowAll = !last;
    }

    public boolean isShowAll() {
        return this.myShowAll;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public void setCharset(Charset charset) {
        this.myCharset = charset;
    }

    public void readExternal(Element element) throws InvalidDataException {
        String file = element.getAttributeValue(PATH);
        if (file != null) {
            file = FileUtil.toSystemDependentName((String)file);
        }
        this.setPathPattern(file);
        Boolean checked = Boolean.valueOf(element.getAttributeValue(CHECKED));
        this.setEnable(checked);
        String skipped = element.getAttributeValue(SKIPPED);
        Boolean skip = skipped != null ? Boolean.valueOf(skipped) : Boolean.TRUE;
        this.setSkipContent(skip);
        String all = element.getAttributeValue(SHOW_ALL);
        Boolean showAll = skipped != null ? Boolean.valueOf(all) : Boolean.TRUE;
        this.setShowAll(showAll);
        this.setName(element.getAttributeValue(ALIAS));
        String charsetStr = element.getAttributeValue(CHARSET);
        try {
            this.setCharset(Charset.forName(charsetStr));
        }
        catch (Exception ignored) {
            this.setCharset(Charset.defaultCharset());
        }
    }

    public void writeExternal(Element element) {
        element.setAttribute(PATH, FileUtil.toSystemIndependentName((String)this.getPathPattern()));
        element.setAttribute(CHECKED, String.valueOf(this.isEnabled()));
        element.setAttribute(SKIPPED, String.valueOf(this.isSkipContent()));
        element.setAttribute(SHOW_ALL, String.valueOf(this.isShowAll()));
        element.setAttribute(ALIAS, this.getName());
        if (!this.getCharset().equals(Charset.defaultCharset())) {
            element.setAttribute(CHARSET, this.getCharset().name());
        }
    }

    public static boolean areEqual(@Nullable LogFileOptions options1, @Nullable LogFileOptions options2) {
        if (options1 == null || options2 == null) {
            return options1 == options2;
        }
        return options1.myName.equals(options2.myName) && options1.myPathPattern.equals(options2.myPathPattern) && !options1.myShowAll == !options2.myShowAll && options1.myEnabled == options2.myEnabled && options1.mySkipContent == options2.mySkipContent;
    }
}

