/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push;

import com.intellij.dvcs.push.CommitLoader;
import com.intellij.dvcs.push.VcsErrorHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsError {
    @NotNull
    String myErrorText;
    @Nullable
    private final VcsErrorHandler myErrorHandleListener;

    public VcsError(@NotNull String text) {
        this(text, null);
    }

    public VcsError(@NotNull String text, @Nullable VcsErrorHandler listener) {
        this.myErrorText = text;
        this.myErrorHandleListener = listener;
    }

    public String getText() {
        return this.myErrorText;
    }

    public void handleError(@NotNull CommitLoader loader) {
        if (this.myErrorHandleListener != null) {
            this.myErrorHandleListener.handleError(loader);
        }
    }

    public static VcsError createEmptyTargetError(@NotNull String name) {
        return new VcsError("Please, specify not empty remote push path for repository " + name + ".");
    }
}

