/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.openapi.editor.Document;
import org.jetbrains.annotations.NotNull;

public class LineCol {
    public final int line;
    public final int column;

    public LineCol(int line) {
        this(line, 0);
    }

    public LineCol(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineCol col = (LineCol)o;
        if (this.line != col.line) {
            return false;
        }
        return this.column == col.column;
    }

    public int hashCode() {
        int result = this.line;
        result = 31 * result + this.column;
        return result;
    }

    public String toString() {
        return String.format("{ line: %s, column: %s }", this.line, this.column);
    }

    @NotNull
    public static LineCol fromOffset(@NotNull Document document, int offset) {
        int line = document.getLineNumber(offset);
        int column = offset - document.getLineStartOffset(line);
        return new LineCol(line, column);
    }

    public static int toOffset(@NotNull Document document, @NotNull LineCol linecol) {
        return document.getLineStartOffset(linecol.line) + linecol.column;
    }
}

