/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeToolState {
    private NamedScope myScope;
    @NotNull
    private final String myScopeName;
    private InspectionToolWrapper myToolWrapper;
    private boolean myEnabled;
    private HighlightDisplayLevel myLevel;
    private boolean myAdditionalConfigPanelCreated = false;
    private JComponent myAdditionalConfigPanel;
    private static final Logger LOG = Logger.getInstance((String)("#" + ScopeToolState.class.getName()));

    public ScopeToolState(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        this(scope.getName(), toolWrapper, enabled, level);
        this.myScope = scope;
    }

    public ScopeToolState(@NotNull String scopeName, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        this.myScopeName = scopeName;
        this.myToolWrapper = toolWrapper;
        this.myEnabled = enabled;
        this.myLevel = level;
    }

    @NotNull
    public ScopeToolState copy() {
        return new ScopeToolState(this.myScopeName, this.myToolWrapper, this.myEnabled, this.myLevel);
    }

    @Nullable
    public NamedScope getScope(Project project) {
        if (this.myScope == null && project != null) {
            this.myScope = NamedScopesHolder.getScope(project, this.myScopeName);
        }
        return this.myScope;
    }

    @NotNull
    public String getScopeName() {
        return this.myScopeName;
    }

    @NotNull
    public InspectionToolWrapper getTool() {
        return this.myToolWrapper;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    @NotNull
    public HighlightDisplayLevel getLevel() {
        return this.myLevel;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void setLevel(@NotNull HighlightDisplayLevel level) {
        this.myLevel = level;
    }

    @Nullable
    public JComponent getAdditionalConfigPanel() {
        if (!this.myAdditionalConfigPanelCreated) {
            this.myAdditionalConfigPanel = ((InspectionProfileEntry)this.myToolWrapper.getTool()).createOptionsPanel();
            this.myAdditionalConfigPanelCreated = true;
        }
        return this.myAdditionalConfigPanel;
    }

    public void resetConfigPanel() {
        this.myAdditionalConfigPanelCreated = false;
        this.myAdditionalConfigPanel = null;
    }

    public void setTool(@NotNull InspectionToolWrapper tool) {
        this.myToolWrapper = tool;
    }

    public boolean equalTo(@NotNull ScopeToolState state2) {
        if (this.isEnabled() != state2.isEnabled()) {
            return false;
        }
        if (this.getLevel() != state2.getLevel()) {
            return false;
        }
        InspectionToolWrapper toolWrapper = this.getTool();
        InspectionToolWrapper toolWrapper2 = state2.getTool();
        if (!toolWrapper.isInitialized() && !toolWrapper2.isInitialized()) {
            return true;
        }
        try {
            String tempRoot = "root";
            Element oldToolSettings = new Element(tempRoot);
            ((InspectionProfileEntry)toolWrapper.getTool()).writeSettings(oldToolSettings);
            Element newToolSettings = new Element(tempRoot);
            ((InspectionProfileEntry)toolWrapper2.getTool()).writeSettings(newToolSettings);
            return JDOMUtil.areElementsEqual((Element)oldToolSettings, (Element)newToolSettings);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public void scopesChanged() {
        this.myScope = null;
    }
}

